/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityThermopneumaticProcessingPlant
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControlled,
ISerializableTanks,
IAutoFluidEjecting,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 6000;
    private static final double MAX_SPEED_UP = 2.5;
    @GuiSynced
    @DescSynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    private final ThermopneumaticFluidTankOutput outputTank = new ThermopneumaticFluidTankOutput(16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    public boolean hasRecipe;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public int minTemperature;
    @GuiSynced
    public int maxTemperature;
    @DescSynced
    private int inputAmountScaled;
    @DescSynced
    private int outputAmountScaled;
    @DescSynced
    private boolean didWork;
    private ThermoPlantRecipe currentRecipe;
    private boolean searchForRecipe = true;
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_190926_b() || PneumaticCraftRecipeType.THERMO_PLANT.stream(TileEntityThermopneumaticProcessingPlant.this.field_145850_b).anyMatch(r -> r.getInputItem().test(stack));
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
        }
    };
    private final ItemStackHandler outputItemHandler = new BaseItemStackHandler(this, 1);
    private final ThermopneumaticInvWrapper invWrapper = new ThermopneumaticInvWrapper((IItemHandler)this.itemHandler, (IItemHandler)this.outputItemHandler);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.invWrapper);
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidHandler);

    public TileEntityThermopneumaticProcessingPlant() {
        super((TileEntityType)ModTileEntities.THERMOPNEUMATIC_PROCESSING_PLANT.get(), 5.0f, 7.0f, 3000, 4);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return this.getRotation().func_176734_d() != dir && dir != Direction.UP;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inputTank.tick();
        this.outputTank.tick();
        if (!this.func_145831_w().field_72995_K) {
            if (this.searchForRecipe || (this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                this.currentRecipe = this.findApplicableRecipe();
                this.searchForRecipe = false;
            }
            this.hasRecipe = this.currentRecipe != null;
            this.didWork = false;
            if (this.hasRecipe) {
                this.requiredPressure = this.currentRecipe.getRequiredPressure();
                this.minTemperature = this.currentRecipe.getOperatingTemperature().getMin();
                this.maxTemperature = this.currentRecipe.getOperatingTemperature().getMax();
                if (this.redstoneAllows() && this.currentRecipe.getOperatingTemperature().inRange(this.heatExchanger.getTemperature()) && this.hasEnoughPressure()) {
                    double inc = this.minTemperature > 0 ? Math.min(2.5, this.heatExchanger.getTemperature() / (double)this.minTemperature) : 1.0;
                    this.craftingProgress = (int)((double)this.craftingProgress + inc * 100.0);
                    if (this.craftingProgress >= 6000) {
                        this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                        this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().func_77946_l(), false);
                        this.inputTank.drain(this.currentRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.itemHandler.extractItem(0, 1, false);
                        this.addAir(-this.currentRecipe.airUsed());
                        this.heatExchanger.addHeat(-this.currentRecipe.heatUsed(this.heatExchanger.getAmbientTemperature()) * inc * 0.75);
                        this.craftingProgress -= 6000;
                    }
                    this.didWork = true;
                }
            } else {
                this.craftingProgress = 0;
                this.minTemperature = 0;
                this.maxTemperature = 0;
                this.requiredPressure = 0.0f;
            }
        } else if (this.didWork && this.func_145831_w().field_73012_v.nextBoolean()) {
            ClientUtils.emitParticles(this.func_145831_w(), this.func_174877_v(), (IParticleData)ParticleTypes.field_197601_L);
        }
    }

    private boolean hasEnoughPressure() {
        if (this.getMinWorkingPressure() == 0.0f) {
            return true;
        }
        if (this.getMinWorkingPressure() > 0.0f) {
            return this.getPressure() >= this.getMinWorkingPressure();
        }
        return this.getPressure() <= this.getMinWorkingPressure();
    }

    private ThermoPlantRecipe findApplicableRecipe() {
        for (ThermoPlantRecipe thermoPlantRecipe : PneumaticCraftRecipeType.THERMO_PLANT.getRecipes(this.field_145850_b).values()) {
            if (!thermoPlantRecipe.matches(this.inputTank.getFluid(), this.itemHandler.getStackInSlot(0))) continue;
            int filled = this.outputTank.fill(thermoPlantRecipe.getOutputFluid(), IFluidHandler.FluidAction.SIMULATE);
            ItemStack excess = this.outputItemHandler.insertItem(0, thermoPlantRecipe.getOutputItem(), true);
            if (filled != thermoPlantRecipe.getOutputFluid().getAmount() || !excess.func_190926_b()) continue;
            return thermoPlantRecipe;
        }
        return null;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 6000.0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_218657_a("Output", (INBT)this.outputItemHandler.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.outputItemHandler.deserializeNBT(tag.func_74775_l("Output"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.craftingProgress = tag.func_74762_e("craftingProgress");
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        FluidStack moved;
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (tag.equals("dump") && !(moved = shiftHeld ? this.inputTank.drain(this.inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)this.inputTank, (int)this.inputTank.getFluidAmount(), (boolean)true)).isEmpty() && player instanceof ServerPlayerEntity) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187630_M, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f, false), (ServerPlayerEntity)player);
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"InputTank", (Object)((Object)this.inputTank), (Object)"OutputTank", (Object)((Object)this.outputTank));
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerThermopneumaticProcessingPlant(i, playerInventory, this.func_174877_v());
    }

    public IItemHandler getOutputInventory() {
        return this.outputItemHandler;
    }

    private class ThermopneumaticInvWrapper
    implements IItemHandler {
        private final IItemHandler input;
        private final IItemHandler output;

        ThermopneumaticInvWrapper(IItemHandler input, IItemHandler output) {
            this.input = input;
            this.output = output;
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.input.getStackInSlot(0) : this.output.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileEntityThermopneumaticProcessingPlant.this.itemHandler.insertItem(0, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityThermopneumaticProcessingPlant.this.outputItemHandler.extractItem(0, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.input.getSlotLimit(0) : this.output.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.input.isItemValid(0, stack) : this.output.isItemValid(0, stack);
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        final FluidTank[] tanks;

        ThermopneumaticFluidHandler() {
            this.tanks = new FluidTank[]{TileEntityThermopneumaticProcessingPlant.this.inputTank, TileEntityThermopneumaticProcessingPlant.this.outputTank};
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return TileEntityThermopneumaticProcessingPlant.this.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid().isFluidEqual(resource) ? TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(resource.getAmount(), doDrain) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(maxDrain, doDrain);
        }
    }

    private class ThermopneumaticFluidTankOutput
    extends SmartSyncTank {
        ThermopneumaticFluidTankOutput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity);
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            FluidStack res = super.drain(resource, doDrain);
            if (doDrain.execute() && !res.isEmpty()) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
            return res;
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            FluidStack res = super.drain(maxDrain, doDrain);
            if (doDrain.execute() && !res.isEmpty()) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
            return res;
        }
    }

    private class ThermopneumaticFluidTankInput
    extends SmartSyncTank {
        private Fluid prevFluid;

        ThermopneumaticFluidTankInput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity);
        }

        public boolean isFluidValid(FluidStack fluid) {
            return fluid.isEmpty() || PneumaticCraftRecipeType.THERMO_PLANT.stream(TileEntityThermopneumaticProcessingPlant.this.field_145850_b).anyMatch(r -> r.getInputFluid().testFluid(fluid.getFluid()));
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            Fluid newFluid = this.getFluid().getFluid();
            if (this.prevFluid != newFluid) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
                this.prevFluid = newFluid;
            }
        }
    }
}

