/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.BlockKeroseneLamp;
import me.desht.pneumaticcraft.common.block.BlockKeroseneLampLight;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerKeroseneLamp;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityKeroseneLamp
extends TileEntityTickableBase
implements IRedstoneControlled,
ISerializableTanks,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.anySignal", (Object)"gui.tab.redstoneBehaviour.button.highSignal", (Object)"gui.tab.redstoneBehaviour.button.lowSignal", (Object)"gui.tab.redstoneBehaviour.keroseneLamp.button.interpolate");
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int LIGHT_SPACING = 3;
    public static final int MAX_RANGE = 30;
    private final Set<BlockPos> managingLights = new HashSet<BlockPos>();
    private boolean isOn;
    @GuiSynced
    private int range;
    @GuiSynced
    private int targetRange = 10;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private int fuel;
    private int checkingX;
    private int checkingY;
    private int checkingZ;
    @DescSynced
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 2000){
        private FluidStack prevFluid;
        {
            this.prevFluid = FluidStack.EMPTY;
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.prevFluid.getFluid() != this.fluid.getFluid()) {
                TileEntityKeroseneLamp.this.recalculateFuelQuality();
            }
            this.prevFluid = this.fluid;
        }
    };
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    @DescSynced
    private float fuelQuality = -1.0f;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileEntityKeroseneLamp() {
        super((TileEntityType)ModTileEntities.KEROSENE_LAMP.get());
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.tank.tick();
        if (!this.func_145831_w().field_72995_K) {
            if (this.fuelQuality < 0.0f) {
                this.recalculateFuelQuality();
            }
            this.processFluidItem(0, 1);
            if (this.func_145831_w().func_82737_E() % 5L == 0L) {
                int realTargetRange;
                int n = realTargetRange = this.redstoneAllows() && this.fuel > 0 ? this.targetRange : 0;
                if (this.redstoneMode == 3) {
                    realTargetRange = (int)((double)this.poweredRedstone / 15.0 * (double)this.targetRange);
                }
                this.updateRange(Math.min(realTargetRange, this.tank.getFluidAmount()));
                this.updateLights();
                this.useFuel();
            }
        } else if (((Boolean)this.func_195044_w().func_177229_b((IProperty)BlockKeroseneLamp.LIT)).booleanValue() && this.func_145831_w().field_73012_v.nextInt(10) == 0) {
            this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)this.func_174877_v().func_177958_n() + 0.4 + 0.2 * this.func_145831_w().field_73012_v.nextDouble(), (double)this.func_174877_v().func_177956_o() + 0.2 + (double)this.tank.getFluidAmount() / 1000.0 * 3.0 / 16.0, (double)this.func_174877_v().func_177952_p() + 0.4 + 0.2 * this.func_145831_w().field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void recalculateFuelQuality() {
        if (!this.tank.isEmpty()) {
            this.fuelQuality = PNCConfig.Common.Machines.keroseneLampCanUseAnyFuel ? (float)PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(this.tank.getFluid().getFluid()) / 110.0f : (this.tank.getFluid().getFluid() == ModFluids.KEROSENE.get() ? 10000.0f : 0.0f);
            this.fuelQuality = (float)((double)this.fuelQuality * PNCConfig.Common.Machines.keroseneLampFuelEfficiency);
        }
    }

    private void useFuel() {
        if (this.fuelQuality == 0.0f) {
            return;
        }
        this.fuel -= this.range * this.range * 3;
        while (this.fuel <= 0 && !this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
            this.fuel = (int)((float)this.fuel + this.fuelQuality);
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.checkingX = this.func_174877_v().func_177958_n();
        this.checkingY = this.func_174877_v().func_177956_o();
        this.checkingZ = this.func_174877_v().func_177952_p();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (BlockPos pos : this.managingLights) {
            if (!this.isLampLight(pos)) continue;
            this.func_145831_w().func_217377_a(pos, false);
        }
    }

    private boolean isLampLight(BlockPos pos) {
        return this.func_145831_w().func_180495_p(pos).func_177230_c() == ModBlocks.KEROSENE_LAMP_LIGHT.get();
    }

    private void updateLights() {
        int roundedRange = this.range / 3 * 3;
        this.checkingX += 3;
        if (this.checkingX > this.func_174877_v().func_177958_n() + roundedRange) {
            this.checkingX = this.func_174877_v().func_177958_n() - roundedRange;
            this.checkingY += 3;
            if (this.checkingY > this.func_174877_v().func_177956_o() + roundedRange) {
                this.checkingY = this.func_174877_v().func_177956_o() - roundedRange;
                this.checkingZ += 3;
                if (this.checkingZ > this.func_174877_v().func_177952_p() + roundedRange) {
                    this.checkingZ = this.func_174877_v().func_177952_p() - roundedRange;
                }
            }
        }
        BlockPos pos = new BlockPos(this.checkingX, this.checkingY, this.checkingZ);
        BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        if (this.managingLights.contains(pos)) {
            if (this.isLampLight(pos)) {
                if (!this.passesRaytraceTest(pos, lampPos)) {
                    this.func_145831_w().func_217377_a(pos, false);
                    this.managingLights.remove(pos);
                }
            } else {
                this.managingLights.remove(pos);
            }
        } else {
            this.tryAddLight(pos, lampPos);
        }
    }

    private void updateRange(int targetRange) {
        if (targetRange > this.range) {
            ++this.range;
            BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            int roundedRange = this.range / 3 * 3;
            for (int x = -roundedRange; x <= roundedRange; x += 3) {
                for (int y = -roundedRange; y <= roundedRange; y += 3) {
                    for (int z = -roundedRange; z <= roundedRange; z += 3) {
                        BlockPos pos = new BlockPos(x + this.func_174877_v().func_177958_n(), y + this.func_174877_v().func_177956_o(), z + this.func_174877_v().func_177952_p());
                        if (this.managingLights.contains(pos)) continue;
                        this.tryAddLight(pos, lampPos);
                    }
                }
            }
        } else if (targetRange < this.range) {
            --this.range;
            Iterator<BlockPos> iterator = this.managingLights.iterator();
            BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                if (!this.isLampLight(pos)) {
                    iterator.remove();
                    continue;
                }
                if (!(PneumaticCraftUtils.distBetween((Vec3i)pos, (Vec3i)lampPos) > (double)this.range)) continue;
                this.func_145831_w().func_217377_a(pos, false);
                iterator.remove();
            }
        }
        boolean wasOn = this.isOn;
        boolean bl = this.isOn = this.range > 0;
        if (this.isOn != wasOn) {
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)BlockKeroseneLamp.LIT, (Comparable)Boolean.valueOf(this.isOn)));
        }
    }

    public boolean isOn() {
        return this.isOn;
    }

    private boolean passesRaytraceTest(BlockPos pos, BlockPos lampPos) {
        RayTraceContext ctx = new RayTraceContext(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), new Vec3d((double)lampPos.func_177958_n() + 0.5, (double)lampPos.func_177956_o() + 0.5, (double)lampPos.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.func_145831_w())));
        BlockRayTraceResult rtr = this.func_145831_w().func_217299_a(ctx);
        return rtr.func_216346_c() == RayTraceResult.Type.BLOCK && rtr.func_216350_a().equals((Object)lampPos);
    }

    private void tryAddLight(BlockPos pos, BlockPos lampPos) {
        if (!PNCConfig.Common.Advanced.disableKeroseneLampFakeAirBlock && PneumaticCraftUtils.distBetween((Vec3i)pos, (Vec3i)lampPos) <= (double)this.range && this.func_145831_w().func_175623_d(pos) && !this.isLampLight(pos) && this.passesRaytraceTest(pos, lampPos)) {
            this.func_145831_w().func_175656_a(pos, ((BlockKeroseneLampLight)ModBlocks.KEROSENE_LAMP_LIGHT.get()).func_176223_P());
            this.managingLights.add(pos);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.func_145831_w().func_72863_F().func_212863_j_().func_215568_a(this.func_174877_v());
        super.onDescUpdate();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("lights", (INBT)this.managingLights.stream().map(NBTUtil::func_186859_a).collect(Collectors.toCollection(ListNBT::new)));
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74774_a("targetRange", (byte)this.targetRange);
        tag.func_74774_a("range", (byte)this.range);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.managingLights.clear();
        ListNBT lights = tag.func_150295_c("lights", 10);
        for (int i = 0; i < lights.size(); ++i) {
            this.managingLights.add(NBTUtil.func_186861_c((CompoundNBT)lights.func_150305_b(i)));
        }
        this.recalculateFuelQuality();
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.targetRange = tag.func_74771_c("targetRange");
        this.range = tag.func_74771_c("range");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else {
            try {
                this.targetRange = MathHelper.func_76125_a((int)Integer.parseInt(tag), (int)1, (int)30);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    public int getRange() {
        return this.range;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public int getFuel() {
        return this.fuel;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    public float getFuelQuality() {
        return this.fuelQuality;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerKeroseneLamp(i, playerInventory, this.func_174877_v());
    }
}

