/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityAerialInterface
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl,
IComparatorSupport,
ISideConfigurable,
INamedContainerProvider {
    private static final int ENERGY_CAPACITY = 100000;
    private static final int RF_PER_TICK = 1000;
    @GuiSynced
    public String playerName = "";
    private String playerUUID = "";
    private Fluid curXpFluid = Fluids.field_204541_a;
    private int curXpRatio = 0;
    @GuiSynced
    public int curXPFluidIndex = -1;
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    public FeedMode feedMode = FeedMode.FRUGAL;
    private boolean oldRedstoneStatus;
    private boolean updateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer = false;
    @GuiSynced
    public boolean dispenserUpgradeInserted;
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private final PlayerExperienceHandler playerExperienceHandler = new PlayerExperienceHandler();
    private final LazyOptional<IFluidHandler> playerExpCap = LazyOptional.of(() -> this.playerExperienceHandler);
    private final PlayerFoodHandler playerFoodHandler = new PlayerFoodHandler();
    private final LazyOptional<IItemHandler> playerFoodCap = LazyOptional.of(() -> this.playerFoodHandler);
    private final PneumaticEnergyStorage energyStorage = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private PlayerCuriosHandler playerCuriosHandler;
    private WeakReference<PlayerEntity> playerRef = new WeakReference<Object>(null);
    private final List<Integer> chargeableSlots = new ArrayList<Integer>();
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.aerialInterface.button.playerConnected");

    public TileEntityAerialInterface() {
        super((TileEntityType)ModTileEntities.AERIAL_INTERFACE.get(), 20.0f, 25.0f, 4000, 4);
        PlayerMainInvHandler playerMainInvHandler = new PlayerMainInvHandler();
        PlayerArmorInvHandler playerArmorInvHandler = new PlayerArmorInvHandler();
        PlayerOffhandInvHandler playerOffhandInvHandler = new PlayerOffhandInvHandler();
        PlayerEnderInvHandler playerEnderInvHandler = new PlayerEnderInvHandler();
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("mainInv", new ItemStack((IItemProvider)Blocks.field_150486_ae), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerMainInvHandler), SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("armorInv", new ItemStack((IItemProvider)ModItems.PNEUMATIC_CHESTPLATE.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerArmorInvHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.registerHandler("offhandInv", new ItemStack((IItemProvider)Items.field_185159_cQ), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerOffhandInvHandler), new SideConfigurator.RelativeFace[0]);
        this.itemHandlerSideConfigurator.registerHandler("enderInv", new ItemStack((IItemProvider)Blocks.field_150477_bB), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerEnderInvHandler), new SideConfigurator.RelativeFace[0]);
        if (Curios.available) {
            this.playerCuriosHandler = new PlayerCuriosHandler();
            this.itemHandlerSideConfigurator.registerHandler("curiosInv", new ItemStack((IItemProvider)Items.field_151045_i), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.playerCuriosHandler), new SideConfigurator.RelativeFace[0]);
        }
    }

    public void setPlayer(PlayerEntity player) {
        this.playerRef = new WeakReference<PlayerEntity>(player);
        boolean wasConnected = this.isConnectedToPlayer;
        if (player == null) {
            this.isConnectedToPlayer = false;
        } else {
            this.setPlayerId(player.func_146103_bH().getName(), player.func_146103_bH().getId().toString());
            this.isConnectedToPlayer = true;
        }
        if (wasConnected != this.isConnectedToPlayer) {
            this.updateNeighbours = true;
            this.func_70296_d();
        }
    }

    private void setPlayerId(String username, String uuid) {
        if (!this.playerUUID.equals(uuid)) {
            this.updateNeighbours = true;
            this.scanForChargeableItems();
            if (Curios.available) {
                this.playerCuriosHandler.invalidate();
            }
            this.func_70296_d();
        }
        this.playerUUID = uuid;
        this.playerName = username;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        boolean wasInserted = this.dispenserUpgradeInserted;
        boolean bl = this.dispenserUpgradeInserted = this.getUpgrades(EnumUpgrade.DISPENSER) > 0;
        if (wasInserted != this.dispenserUpgradeInserted) {
            this.updateNeighbours = true;
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.updateNeighbours) {
            this.updateNeighbours = false;
            this.updateNeighbours();
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.getPressure() >= this.getMinWorkingPressure() && this.isConnectedToPlayer) {
                PlayerEntity player;
                this.addAir(-1);
                if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                    this.scanForChargeableItems();
                }
                this.supplyEnergyToPlayer();
                if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L && (player = this.getPlayer()) != null && player.func_70086_ai() <= 280) {
                    player.func_70050_g(player.func_70086_ai() + 16);
                    this.addAir(-80);
                }
            }
            if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L && !this.playerUUID.isEmpty()) {
                this.setPlayer(PneumaticCraftUtils.getPlayerFromId(this.playerUUID));
            }
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours = true;
        }
        super.func_73660_a();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        } else if (tag.equals("xpType")) {
            ++this.curXPFluidIndex;
            List<Fluid> available = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (this.curXPFluidIndex >= available.size()) {
                this.curXPFluidIndex = -1;
            }
            this.curXpFluid = this.curXPFluidIndex >= 0 && this.curXPFluidIndex < available.size() ? available.get(this.curXPFluidIndex) : Fluids.field_204541_a;
            this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        } else if (tag.startsWith("SideConf") && this.itemHandlerSideConfigurator.handleButtonPress(tag)) {
            this.updateNeighbours = true;
        } else {
            try {
                this.feedMode = FeedMode.valueOf(tag);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.func_70296_d();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isConnectedToPlayer;
            }
        }
        return false;
    }

    private PlayerEntity getPlayer() {
        return (PlayerEntity)this.playerRef.get();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.dispenserUpgradeInserted) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.playerFoodCap);
            }
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerSideConfigurator.getHandler(side));
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dispenserUpgradeInserted && this.curXpFluid != Fluids.field_204541_a) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.playerExpCap);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.feedMode = FeedMode.valueOf(tag.func_74779_i("feedMode"));
        this.setPlayerId(tag.func_74779_i("playerName"), tag.func_74779_i("playerUUID"));
        this.curXpFluid = tag.func_74764_b("curXpFluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("curXpFluid"))) : Fluids.field_204541_a;
        this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        this.energyStorage.readFromNBT(tag);
        this.curXPFluidIndex = this.curXpFluid == Fluids.field_204541_a ? -1 : XPFluidManager.getInstance().getAvailableLiquidXPs().indexOf(this.curXpFluid);
        this.dispenserUpgradeInserted = this.getUpgrades(EnumUpgrade.DISPENSER) > 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74778_a("feedMode", this.feedMode.toString());
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74778_a("playerUUID", this.playerUUID);
        tag.func_74778_a("curXpFluid", this.curXpFluid.getRegistryName().toString());
        this.energyStorage.writeToNBT(tag);
        return tag;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public int getComparatorValue() {
        return this.shouldEmitRedstone() ? 15 : 0;
    }

    private void scanForChargeableItems() {
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        this.chargeableSlots.clear();
        if (this.isConnectedToPlayer) {
            PlayerInventory inv = ((PlayerEntity)this.playerRef.get()).field_71071_by;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (!inv.func_70301_a(i).getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
                this.chargeableSlots.add(i);
            }
        }
    }

    private void supplyEnergyToPlayer() {
        int slot;
        ItemStack stack;
        int energyLeft;
        if (!this.isConnectedToPlayer || this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        PlayerInventory inv = ((PlayerEntity)this.playerRef.get()).field_71071_by;
        Iterator<Integer> iterator = this.chargeableSlots.iterator();
        while (iterator.hasNext() && (energyLeft = ((Integer)(stack = inv.func_70301_a(slot = iterator.next().intValue())).getCapability(CapabilityEnergy.ENERGY).map(receivingStorage -> {
            int stored = this.energyStorage.getEnergyStored();
            if (stored > 0) {
                this.energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(stored, 1000), false), false);
            }
            return this.energyStorage.getEnergyStored();
        }).orElse((Object)this.energyStorage.getEnergyStored())).intValue()) != 0) {
        }
        if (Curios.available && this.energyStorage.getEnergyStored() > 0) {
            Curios.chargeItems(this.getPlayer(), this.energyStorage, 1000);
        }
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerEnergy((ContainerType)ModContainers.AERIAL_INTERFACE.get(), i, playerInventory, this.func_174877_v());
    }

    public static enum FeedMode {
        FRUGAL("frugal", Items.field_151083_be),
        GREEDY("greedy", Items.field_151034_e),
        SMART("smart", Items.field_151153_ao);

        private final String key;
        private final ItemStack stack;

        private FeedMode(String key, Item item) {
            this.key = key;
            this.stack = new ItemStack((IItemProvider)item);
        }

        public String getTranslationKey() {
            return "gui.tab.info.aerialInterface.feedMode." + this.key;
        }

        public String getDescTranslationKey() {
            return "gui.tab.info.aerialInterface.feedMode." + this.key + ".desc";
        }

        public ItemStack getIconStack() {
            return this.stack;
        }
    }

    private class PlayerExperienceHandler
    implements IFluidHandler {
        private PlayerExperienceHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            PlayerEntity player;
            if (TileEntityAerialInterface.this.curXpFluid != Fluids.field_204541_a && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                return new FluidStack(TileEntityAerialInterface.this.curXpFluid, EnchantmentUtils.getPlayerXP(player) * TileEntityAerialInterface.this.curXpRatio);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return TileEntityAerialInterface.this.curXpFluid != Fluids.field_204541_a && stack.getFluid() == TileEntityAerialInterface.this.curXpFluid;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            PlayerEntity player;
            if (TileEntityAerialInterface.this.curXpRatio != 0 && this.canFill(resource.getFluid()) && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                int pointsAdded = resource.getAmount() / TileEntityAerialInterface.this.curXpRatio;
                if (doFill.execute()) {
                    player.func_195068_e(pointsAdded);
                }
                return pointsAdded * TileEntityAerialInterface.this.curXpRatio;
            }
            return 0;
        }

        private boolean canFill(Fluid fluid) {
            return TileEntityAerialInterface.this.dispenserUpgradeInserted && fluid != Fluids.field_204541_a && fluid == TileEntityAerialInterface.this.curXpFluid && TileEntityAerialInterface.this.curXpRatio != 0 && TileEntityAerialInterface.this.getPlayer() != null && TileEntityAerialInterface.this.getPressure() >= TileEntityAerialInterface.this.getMinWorkingPressure();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            PlayerEntity player;
            if (TileEntityAerialInterface.this.curXpRatio != 0 && this.canDrain(resource.getFluid()) && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                int pointsDrained = Math.min(EnchantmentUtils.getPlayerXP(player), resource.getAmount() / TileEntityAerialInterface.this.curXpRatio);
                if (doDrain.execute()) {
                    EnchantmentUtils.addPlayerXP(player, -pointsDrained);
                }
                return new FluidStack(resource.getFluid(), pointsDrained * TileEntityAerialInterface.this.curXpRatio);
            }
            return FluidStack.EMPTY;
        }

        private boolean canDrain(Fluid fluid) {
            return TileEntityAerialInterface.this.dispenserUpgradeInserted && TileEntityAerialInterface.this.getPlayer() != null && TileEntityAerialInterface.this.getPressure() >= TileEntityAerialInterface.this.getMinWorkingPressure();
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (TileEntityAerialInterface.this.curXpFluid == Fluids.field_204541_a) {
                return FluidStack.EMPTY;
            }
            return this.drain(new FluidStack(TileEntityAerialInterface.this.curXpFluid, maxDrain), doDrain);
        }
    }

    private class PlayerFoodHandler
    implements IItemHandler {
        private PlayerFoodHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (TileEntityAerialInterface.this.getPressure() < TileEntityAerialInterface.this.getMinWorkingPressure()) {
                return stack;
            }
            PlayerEntity player = TileEntityAerialInterface.this.getPlayer();
            if (player == null || this.getFoodValue(stack) <= 0 || !this.okToFeed(stack, player)) {
                return stack;
            }
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            int startValue = stack.func_190916_E();
            ItemStack remainingItem = stack;
            while (stack.func_190916_E() > 0) {
                remainingItem = stack.func_77950_b(player.field_70170_p, (LivingEntity)player);
                if (!((remainingItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack, (int)0, (ItemStack)remainingItem)).func_190916_E() <= 0 || remainingItem == stack && remainingItem.func_190916_E() == startValue || player.field_71071_by.func_70441_a(remainingItem) || remainingItem.func_190916_E() <= 0)) {
                    player.func_71019_a(remainingItem, false);
                }
                if (stack.func_190916_E() != startValue) continue;
            }
            return remainingItem.func_190916_E() > 0 ? remainingItem : ItemStack.field_190927_a;
        }

        private boolean okToFeed(@Nonnull ItemStack stack, PlayerEntity player) {
            int foodValue = this.getFoodValue(stack);
            int curFoodLevel = player.func_71024_bL().func_75116_a();
            FeedMode effectiveFeedMode = TileEntityAerialInterface.this.feedMode == FeedMode.SMART ? (player.func_110143_aJ() < player.func_110138_aP() ? FeedMode.GREEDY : FeedMode.FRUGAL) : TileEntityAerialInterface.this.feedMode;
            switch (effectiveFeedMode) {
                case FRUGAL: {
                    return 20 - curFoodLevel >= foodValue * stack.func_190916_E();
                }
                case GREEDY: {
                    return 20 - curFoodLevel >= foodValue * (stack.func_190916_E() - 1) + 1;
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getFoodValue(stack) > 0;
        }

        private int getFoodValue(ItemStack stack) {
            return stack.func_77973_b().func_219971_r() ? stack.func_77973_b().func_219967_s().func_221466_a() : 0;
        }
    }

    private class PlayerCuriosHandler
    extends PlayerInvHandler {
        IItemHandler combined;

        private PlayerCuriosHandler() {
            this.combined = null;
        }

        @Override
        protected IItemHandler getInvWrapper() {
            if (this.combined == null) {
                this.combined = Curios.makeCombinedInvWrapper(TileEntityAerialInterface.this.getPlayer());
            }
            return this.combined;
        }

        void invalidate() {
            this.combined = null;
        }
    }

    private class PlayerEnderInvHandler
    extends PlayerInvHandler {
        private PlayerEnderInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new InvWrapper((IInventory)TileEntityAerialInterface.this.getPlayer().func_71005_bN());
        }
    }

    private class PlayerOffhandInvHandler
    extends PlayerInvHandler {
        private PlayerOffhandInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerOffhandInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private class PlayerArmorInvHandler
    extends PlayerInvHandler {
        private PlayerArmorInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerArmorInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private class PlayerMainInvHandler
    extends PlayerInvHandler {
        private PlayerMainInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerMainInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private abstract class PlayerInvHandler
    implements IItemHandler {
        private PlayerInvHandler() {
        }

        protected abstract IItemHandler getInvWrapper();

        public int getSlots() {
            return TileEntityAerialInterface.this.playerRef.get() == null ? 0 : this.getInvWrapper().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? ItemStack.field_190927_a : this.getInvWrapper().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (TileEntityAerialInterface.this.playerRef.get() == null || TileEntityAerialInterface.this.getPressure() < TileEntityAerialInterface.this.getMinWorkingPressure()) {
                return stack;
            }
            return this.getInvWrapper().insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileEntityAerialInterface.this.playerRef.get() == null || TileEntityAerialInterface.this.getPressure() < TileEntityAerialInterface.this.getMinWorkingPressure()) {
                return ItemStack.field_190927_a;
            }
            return this.getInvWrapper().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? 1 : this.getInvWrapper().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

