/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public enum SemiblockTracker {
    INSTANCE;

    private static final Map<ResourceLocation, Map<BlockPos, SemiblockCollection>> semiblockMap;

    public static SemiblockTracker getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
        if (!event.getServer().func_71262_S()) {
            semiblockMap.values().forEach(Map::clear);
            semiblockMap.clear();
        }
    }

    public ISemiBlock getSemiblock(World world, BlockPos pos) {
        return this.getSemiblock(world, pos, null);
    }

    public ISemiBlock getSemiblock(World world, BlockPos pos, Direction direction) {
        Map<BlockPos, SemiblockCollection> map = semiblockMap.get(this.getKey(world));
        if (map == null) {
            return null;
        }
        SemiblockCollection sc = map.get(pos);
        return sc == null ? null : sc.get(direction);
    }

    public Stream<ISemiBlock> getAllSemiblocks(World world, BlockPos pos) {
        return this.getAllSemiblocks(world, pos, null);
    }

    public Stream<ISemiBlock> getAllSemiblocks(World world, BlockPos pos, Direction offsetDir) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        if (map.isEmpty()) {
            return Stream.empty();
        }
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null && offsetDir != null) {
            sc = (SemiblockCollection)map.get(pos.func_177972_a(offsetDir));
        }
        return sc == null ? Stream.empty() : sc.getAll();
    }

    public void clearSemiblock(World world, BlockPos pos, Direction direction) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc != null) {
            sc.clear(direction);
        }
    }

    public boolean putSemiblock(World world, BlockPos pos, ISemiBlock entity) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null) {
            map.put(pos, new SemiblockCollection(entity));
            return true;
        }
        return sc.set(entity);
    }

    public Stream<ISemiBlock> getSemiblocksInArea(World world, AxisAlignedBB aabb) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        return map.entrySet().stream().filter(e -> aabb.func_197744_e((double)((BlockPos)e.getKey()).func_177958_n(), (double)((BlockPos)e.getKey()).func_177956_o(), (double)((BlockPos)e.getKey()).func_177952_p())).flatMap(e -> ((SemiblockCollection)e.getValue()).getAll());
    }

    private ResourceLocation getKey(World world) {
        return world.func_201675_m().func_186058_p().getRegistryName();
    }

    static {
        semiblockMap = new HashMap<ResourceLocation, Map<BlockPos, SemiblockCollection>>();
    }

    private static class SemiblockCollection {
        private WeakReference<ISemiBlock> center = new WeakReference<Object>(null);
        private final List<WeakReference<ISemiBlock>> sides = new ArrayList<WeakReference<ISemiBlock>>();

        SemiblockCollection(ISemiBlock e) {
            this.set(e);
        }

        public ISemiBlock get(Direction direction) {
            if (direction == null) {
                return (ISemiBlock)this.center.get();
            }
            return this.sides.isEmpty() ? null : (ISemiBlock)this.sides.get(direction.func_176745_a()).get();
        }

        boolean set(ISemiBlock semiBlock) {
            Direction dir;
            Direction direction = dir = semiBlock instanceof IDirectionalSemiblock ? ((IDirectionalSemiblock)((Object)semiBlock)).getSide() : null;
            if (dir == null) {
                if (this.center.get() != null) {
                    return false;
                }
                this.center = new WeakReference<ISemiBlock>(semiBlock);
            } else {
                if (this.sides.isEmpty()) {
                    for (int i = 0; i < 6; ++i) {
                        this.sides.add(new WeakReference<Object>(null));
                    }
                }
                if (this.sides.get(dir.func_176745_a()).get() != null) {
                    return false;
                }
                this.sides.set(dir.func_176745_a(), new WeakReference<ISemiBlock>(semiBlock));
            }
            return true;
        }

        public void clear(Direction direction) {
            if (direction == null) {
                if (this.center != null) {
                    this.center.clear();
                }
            } else if (!this.sides.isEmpty()) {
                this.sides.get(direction.func_176745_a()).clear();
            }
        }

        Stream<ISemiBlock> getAll() {
            Stream s1 = this.center.get() == null ? Stream.empty() : Stream.of(this.center.get());
            Stream<ISemiBlock> s2 = this.sides.stream().filter(ref -> ref.get() != null).map(Reference::get);
            return Stream.concat(s1, s2);
        }
    }
}

