/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIForEachCoordinate;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ProgWidgetForEachCoordinate
extends ProgWidgetAreaItemBase
implements IJumpBackWidget,
IJump,
IVariableSetWidget {
    private String elementVariable = "";
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private DroneAIForEachCoordinate ai;

    public ProgWidgetForEachCoordinate() {
        super(ModProgWidgets.FOR_EACH_COORDINATE);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_FOR_EACH_COORDINATE;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.TEXT);
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        variables.add(this.elementVariable);
    }

    @Override
    public String getVariable() {
        return this.elementVariable;
    }

    @Override
    public void setVariable(String variable) {
        this.elementVariable = variable;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("variable", this.elementVariable);
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.elementVariable = tag.func_74779_i("variable");
        super.readFromNBT(tag);
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.func_180714_a(this.elementVariable);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.elementVariable = buf.func_150789_c(64);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        BlockPos pos;
        List<String> locations = this.getPossibleJumpLocations();
        if (!(locations.size() <= 0 || this.ai == null || this.traversedPositions.size() != 1 && this.aiManager.getCoordinate(this.elementVariable).equals((Object)BlockPos.field_177992_a) || (pos = this.ai.getCurCoord()) == null)) {
            this.aiManager.setCoordinate(this.elementVariable, pos);
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.get(0));
        }
        this.traversedPositions.clear();
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        ProgWidgetText textWidget = widget != null ? (ProgWidgetText)widget : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        return locations;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        this.ai = new DroneAIForEachCoordinate(drone, (ProgWidgetForEachCoordinate)widget);
        return this.ai;
    }

    public boolean isValidPosition(BlockPos pos) {
        return this.traversedPositions.add(pos);
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.elementVariable + "\"";
    }

    @Override
    public boolean canSetParameter(int index) {
        return index != 2;
    }
}

