/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawnParticle
extends LocationDoublePacket {
    private IParticleData particle;
    private double dx;
    private double dy;
    private double dz;
    private int numParticles;
    private double rx;
    private double ry;
    private double rz;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(IParticleData particle, double x, double y, double z, double dx, double dy, double dz) {
        super(x, y, z);
        this.particle = particle;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.numParticles = 1;
        this.rz = 0.0;
        this.ry = 0.0;
        this.rx = 0.0;
    }

    public PacketSpawnParticle(IParticleData particle, double x, double y, double z, double dx, double dy, double dz, int numParticles, double rx, double ry, double rz) {
        this(particle, x, y, z, dx, dy, dz);
        this.numParticles = numParticles;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public PacketSpawnParticle(PacketBuffer buffer) {
        super(buffer);
        ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.func_192575_l());
        assert (type != null);
        this.dx = buffer.readDouble();
        this.dy = buffer.readDouble();
        this.dz = buffer.readDouble();
        this.numParticles = buffer.readInt();
        if (this.numParticles > 1) {
            this.rx = buffer.readDouble();
            this.ry = buffer.readDouble();
            this.rz = buffer.readDouble();
        }
        this.particle = this.readParticle(type, buffer);
    }

    private <T extends IParticleData> T readParticle(ParticleType<T> type, PacketBuffer buffer) {
        return (T)type.func_197571_g().func_197543_b(type, buffer);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.func_192572_a(this.particle.func_197554_b().getRegistryName());
        buffer.writeDouble(this.dx);
        buffer.writeDouble(this.dy);
        buffer.writeDouble(this.dz);
        buffer.writeInt(this.numParticles);
        if (this.numParticles > 1) {
            buffer.writeDouble(this.rx);
            buffer.writeDouble(this.ry);
            buffer.writeDouble(this.rz);
        }
        this.particle.func_197553_a(new PacketBuffer((ByteBuf)buffer));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ClientUtils.getClientWorld();
            for (int i = 0; i < this.numParticles; ++i) {
                double x1 = this.x + (this.numParticles == 1 ? 0.0 : world.field_73012_v.nextDouble() * this.rx);
                double y1 = this.y + (this.numParticles == 1 ? 0.0 : world.field_73012_v.nextDouble() * this.ry);
                double z1 = this.z + (this.numParticles == 1 ? 0.0 : world.field_73012_v.nextDouble() * this.rz);
                world.func_195594_a(this.particle, x1, y1, z1, this.dx, this.dy, this.dz);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

