/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDescription
extends LocationIntPacket {
    private boolean fullSync;
    private final List<IndexedField> fields = new ArrayList<IndexedField>();
    private CompoundNBT extraData;

    public PacketDescription() {
    }

    public PacketDescription(IDescSynced te, boolean fullSync) {
        super(te.getPosition());
        this.fullSync = fullSync;
        List<SyncedField> descFields = te.getDescriptionFields();
        for (int i = 0; i < descFields.size(); ++i) {
            if (!fullSync && !te.shouldSyncField(i)) continue;
            this.fields.add(new IndexedField(i, SyncedField.getType(descFields.get(i)), descFields.get(i).getValue()));
        }
        this.extraData = new CompoundNBT();
        te.writeToPacket(this.extraData);
    }

    public PacketDescription(PacketBuffer buf) {
        super(buf);
        this.fullSync = buf.readBoolean();
        int fieldCount = buf.func_150792_a();
        for (int i = 0; i < fieldCount; ++i) {
            int idx = this.fullSync ? i : buf.func_150792_a();
            byte type = buf.readByte();
            this.fields.add(new IndexedField(idx, type, SyncedField.fromBytes(buf, type)));
        }
        this.extraData = buf.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.fullSync);
        buf.func_150787_b(this.fields.size());
        for (IndexedField indexedField : this.fields) {
            if (!this.fullSync) {
                buf.func_150787_b(indexedField.idx);
            }
            buf.writeByte((int)indexedField.type);
            SyncedField.toBytes(buf, indexedField.value, indexedField.type);
        }
        buf.func_150786_a(this.extraData);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::process);
        ctx.get().setPacketHandled(true);
    }

    public void process() {
        TileEntity syncable;
        if (ClientUtils.getClientWorld().isAreaLoaded(this.pos, 0) && (syncable = ClientUtils.getClientTE(this.pos)) instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)syncable;
            List<SyncedField> descFields = descSynced.getDescriptionFields();
            if (descFields != null) {
                for (IndexedField indexedField : this.fields) {
                    if (indexedField.idx >= descFields.size()) continue;
                    descFields.get(indexedField.idx).setValue(indexedField.value);
                }
            }
            descSynced.readFromPacket(this.extraData);
            descSynced.onDescUpdate();
        }
    }

    public CompoundNBT writeNBT(CompoundNBT compound) {
        CompoundNBT subTag = new CompoundNBT();
        subTag.func_74768_a("Length", this.fields.size());
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        ListNBT list = new ListNBT();
        for (IndexedField field : this.fields) {
            CompoundNBT element = new CompoundNBT();
            element.func_74774_a("Type", field.type);
            buf.clear();
            SyncedField.toBytes(buf, field.value, field.type);
            element.func_74773_a("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
            list.add(list.size(), (INBT)element);
        }
        buf.release();
        subTag.func_218657_a("Data", (INBT)list);
        subTag.func_218657_a("Extra", (INBT)this.extraData);
        compound.func_218657_a("pneumaticcraft", (INBT)subTag);
        return compound;
    }

    public PacketDescription(CompoundNBT compound) {
        super(new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")));
        CompoundNBT subTag = compound.func_74775_l("pneumaticcraft");
        int fieldCount = subTag.func_74762_e("Length");
        ListNBT list = subTag.func_150295_c("Data", 10);
        for (int i = 0; i < fieldCount; ++i) {
            CompoundNBT element = list.func_150305_b(i);
            byte type = element.func_74771_c("Type");
            byte[] b = element.func_74770_j("Value");
            this.fields.add(new IndexedField(i, type, SyncedField.fromBytes(new PacketBuffer(Unpooled.wrappedBuffer((byte[])b)), type)));
        }
        this.extraData = subTag.func_74775_l("Extra");
    }

    public boolean hasData() {
        return !this.fields.isEmpty() || !this.extraData.isEmpty();
    }

    private static class IndexedField {
        final int idx;
        final byte type;
        final Object value;

        IndexedField(int idx, byte type, Object value) {
            this.idx = idx;
            this.type = type;
            this.value = value;
        }
    }
}

