/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerRemote;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketNotifyVariablesRemote;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.GlobalPosUtils;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemRemote
extends Item {
    private static final String NBT_SECURITY_POS = "securityPos";

    public ItemRemote() {
        super(ModItems.defaultProps().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K) {
            this.openGui(player, stack, handIn);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack remote, ItemUseContext ctx) {
        TileEntity te;
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K && !player.func_225608_bj_() && this.isAllowedToEdit(player, remote) && (te = world.func_175625_s(pos)) instanceof TileEntitySecurityStation) {
            if (((TileEntitySecurityStation)te).doesAllowPlayer(player)) {
                GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos);
                ItemRemote.setSecurityStationPos(remote, gPos);
                player.func_146105_b(PneumaticCraftUtils.xlate("gui.remote.boundSecurityStation", gPos.toString()), true);
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b(PneumaticCraftUtils.xlate("gui.remote.cantBindSecurityStation", new Object[0]), true);
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack remote, World world, List<ITextComponent> curInfo, ITooltipFlag moreInfo) {
        super.func_77624_a(remote, world, curInfo, moreInfo);
        curInfo.add(PneumaticCraftUtils.xlate("gui.remote.tooltip.sneakRightClickToEdit", new Object[0]));
        GlobalPos gPos = ItemRemote.getSecurityStationPos(remote);
        if (gPos != null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.remote.tooltip.boundToSecurityStation", gPos.toString()));
        } else {
            curInfo.add(PneumaticCraftUtils.xlate("gui.remote.tooltip.rightClickToBind", new Object[0]));
        }
    }

    private void openGui(PlayerEntity player, ItemStack remote, Hand hand) {
        if (player.func_213453_ef()) {
            if (this.isAllowedToEdit(player, remote)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new RemoteEditorContainerProvider(remote, hand), buf -> buf.writeBoolean(hand == Hand.MAIN_HAND));
                NetworkHandler.sendToPlayer(new PacketNotifyVariablesRemote(GlobalVariableManager.getInstance().getAllActiveVariableNames()), (ServerPlayerEntity)player);
            }
        } else {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new RemoteContainerProvider(remote, hand), buf -> buf.writeBoolean(hand == Hand.MAIN_HAND));
        }
    }

    public static boolean hasSameSecuritySettings(ItemStack remote1, ItemStack remote2) {
        GlobalPos g1 = ItemRemote.getSecurityStationPos(remote1);
        GlobalPos g2 = ItemRemote.getSecurityStationPos(remote2);
        return g1 == null && g2 == null || g1 != null && g1.equals((Object)g2);
    }

    private boolean isAllowedToEdit(PlayerEntity player, ItemStack remote) {
        TileEntity te;
        GlobalPos gPos = ItemRemote.getSecurityStationPos(remote);
        if (gPos != null && (te = GlobalPosUtils.getTileEntity(gPos)) instanceof TileEntitySecurityStation) {
            boolean canAccess = ((TileEntitySecurityStation)te).doesAllowPlayer(player);
            if (!canAccess) {
                player.func_146105_b(new TranslationTextComponent("gui.remote.noEditRights", new Object[]{gPos}).func_211708_a(TextFormatting.RED), false);
            }
            return canAccess;
        }
        return true;
    }

    private static GlobalPos getSecurityStationPos(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_SECURITY_POS) ? GlobalPosUtils.deserializeGlobalPos(stack.func_77978_p().func_74775_l(NBT_SECURITY_POS)) : null;
    }

    private static void setSecurityStationPos(ItemStack stack, GlobalPos gPos) {
        NBTUtil.setCompoundTag(stack, NBT_SECURITY_POS, (INBT)GlobalPosUtils.serializeGlobalPos(gPos));
    }

    public void func_77663_a(ItemStack remote, World world, Entity entity, int slot, boolean holdingItem) {
        TileEntity te;
        GlobalPos gPos;
        if (!world.field_72995_K && (gPos = ItemRemote.getSecurityStationPos(remote)) != null && !((te = GlobalPosUtils.getTileEntity(gPos)) instanceof TileEntitySecurityStation) && remote.func_77942_o()) {
            remote.func_77978_p().func_82580_o(NBT_SECURITY_POS);
        }
    }

    static class RemoteEditorContainerProvider
    extends RemoteContainerProvider {
        RemoteEditorContainerProvider(ItemStack stack, Hand hand) {
            super(stack, hand);
        }

        @Override
        protected ContainerType<? extends ContainerRemote> getType() {
            return (ContainerType)ModContainers.REMOTE_EDITOR.get();
        }
    }

    static class RemoteContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;
        private final Hand hand;

        RemoteContainerProvider(ItemStack stack, Hand hand) {
            this.stack = stack;
            this.hand = hand;
        }

        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }

        @Nullable
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new ContainerRemote(this.getType(), windowId, playerInventory, this.hand);
        }

        protected ContainerType<? extends ContainerRemote> getType() {
            return (ContainerType)ModContainers.REMOTE.get();
        }
    }
}

