/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerPneumaticArmor {
    private static final Map<Integer, Integer> targetingTracker = new HashMap<Integer, Integer>();
    private static final Map<UUID, Long> armorJumping = new HashMap<UUID, Long>();
    private static final int ARMOR_REPAIR_AMOUNT = 16;
    private static final Vec3d IDLE_VEC = new Vec3d(0.0, -0.5, 0.0);

    @SubscribeEvent
    public void onMobTargetSet(LivingSetAttackTargetEvent event) {
        int mobId = event.getEntityLiving().func_145782_y();
        if (event.getTarget() instanceof ServerPlayerEntity) {
            CommonArmorHandler handler;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getTarget();
            if (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, EquipmentSlotType.HEAD) && (!targetingTracker.containsKey(mobId) || targetingTracker.get(mobId).intValue() != event.getTarget().func_145782_y()) && (handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player)).isArmorReady(EquipmentSlotType.HEAD) && handler.getArmorPressure(EquipmentSlotType.HEAD) > 0.0f && handler.isEntityTrackerEnabled()) {
                NetworkHandler.sendToPlayer(new PacketSendArmorHUDMessage("pneumaticHelmet.message.targetWarning", 60, 1895776256, event.getEntityLiving().func_200200_C_().func_150254_d()), player);
            }
            targetingTracker.put(mobId, event.getTarget().func_145782_y());
        } else {
            targetingTracker.remove(mobId);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        targetingTracker.remove(event.getEntityLiving().func_145782_y());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        long when = armorJumping.getOrDefault(player.func_110124_au(), 0L);
        if (player.field_70170_p.func_82737_E() - when < 40L) {
            event.setCanceled(true);
            return;
        }
        armorJumping.remove(player.func_110124_au());
        if (event.getDistance() > 3.0f) {
            ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (!handler.isArmorEnabled()) {
                return;
            }
            if (event.getEntity().field_70170_p.func_175659_aa() == Difficulty.HARD && handler.isJetBootsActive()) {
                event.setDamageMultiplier(0.2f);
                return;
            }
            float airNeeded = event.getDistance() * 20.0f;
            int vol = (Integer)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getVolume).orElse((Object)0);
            float airAvailable = (float)vol * handler.getArmorPressure(EquipmentSlotType.FEET);
            if (airAvailable < 1.0f) {
                return;
            }
            if (airAvailable >= airNeeded) {
                event.setCanceled(true);
            } else {
                event.setDamageMultiplier(1.0f - airAvailable / airNeeded);
            }
            int i = 0;
            while ((float)i < event.getDistance() / 2.0f) {
                float sx = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                float sz = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sx, 0.1, sz), player.field_70170_p);
                ++i;
            }
            NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.SHORT_HISS.get(), SoundCategory.PLAYERS, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.3f, 0.8f, false), player.field_70170_p);
            handler.addAir(EquipmentSlotType.FEET, (int)(-airNeeded));
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            Minigun minigun;
            ItemStack stack;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.CHEST) && event.getSource().func_76347_k()) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                if (handler.isArmorEnabled() && handler.getArmorPressure(EquipmentSlotType.CHEST) > 0.1f && handler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.SECURITY) > 0) {
                    event.setCanceled(true);
                    player.func_70066_B();
                    if (!player.field_70170_p.field_72995_K) {
                        handler.addAir(EquipmentSlotType.CHEST, -50);
                        for (int i = 0; i < 2; ++i) {
                            float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_() + (double)sx, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (double)sz, sx / 4.0f, -0.2, sz / 4.0f), player.field_70170_p);
                        }
                        if ((player.field_70173_aa & 0xF) == 0) {
                            NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.LEAKING_GAS.get(), SoundCategory.PLAYERS, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.5f, 0.7f, false), player.field_70170_p);
                            this.tryExtinguish(player);
                        }
                    }
                }
            } else if (event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_180139_w() && event.getSource().func_76346_g() instanceof GuardianEntity && (stack = player.func_184614_ca()).func_77973_b() instanceof ItemMinigun && (minigun = ((ItemMinigun)stack.func_77973_b()).getMinigun(stack, player)) != null && minigun.getMinigunSpeed() >= 0.4f) {
                event.setCanceled(true);
            }
        }
    }

    private void tryExtinguish(PlayerEntity player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.func_180425_c().func_177982_a(i, 0, j);
                BlockState state = player.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150480_ab && player.func_70681_au().nextInt(3) == 0) {
                    player.field_70170_p.func_217377_a(pos, false);
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150353_l || player.func_70681_au().nextInt(5) != 0) continue;
                int level = (Integer)state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b);
                player.field_70170_p.func_175656_a(pos, level == 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150347_e.func_176223_P());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.LEGS);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (!handler.isJetBootsEnabled() && handler.isArmorReady(EquipmentSlotType.LEGS) && handler.isJumpBoostEnabled() && handler.getArmorPressure(EquipmentSlotType.LEGS) > 0.01f) {
                float power = (float)ItemPneumaticArmor.getIntData(stack, "jumpBoost", 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EquipmentSlotType.LEGS, EnumUpgrade.JUMPING, player.func_225608_bj_() ? 1 : 4);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                float scale = player.func_70051_ag() ? 0.3f * actualBoost : 0.225f * actualBoost;
                float rotRad = player.field_70177_z * ((float)Math.PI / 180);
                Vec3d m = player.func_213322_ci();
                double addX = m.field_72450_a == 0.0 ? 0.0 : -((double)(MathHelper.func_76126_a((float)rotRad) * scale));
                double addZ = m.field_72449_c == 0.0 ? 0.0 : (double)(MathHelper.func_76134_b((float)rotRad) * scale);
                player.func_213293_j(m.field_72450_a + addX, m.field_72448_b + (double)(actualBoost * 0.15f), m.field_72449_c + addZ);
                armorJumping.put(player.func_110124_au(), player.field_70170_p.func_82737_E());
                int airUsed = (int)Math.ceil(25.0f * actualBoost * (float)(player.func_70051_ag() ? 2 : 1));
                handler.addAir(EquipmentSlotType.LEGS, -airUsed);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedCheck(PlayerEvent.BreakSpeed event) {
        int n;
        CommonArmorHandler handler;
        PlayerEntity player = event.getPlayer();
        int max = 5;
        if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(event.getPlayer())).isJetBootsEnabled() && !player.field_70122_E && handler.isJetBootsBuilderMode() && (n = max + 1 - handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS, max)) < 4) {
            float newSpeed;
            float mult = 5.0f / (float)n;
            float oldSpeed = event.getOriginalSpeed();
            if (oldSpeed < (newSpeed = event.getNewSpeed()) * mult) {
                event.setNewSpeed(newSpeed * mult);
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        CommonArmorHandler handler;
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && ItemPneumaticArmor.isPneumaticArmorPiece(player = (PlayerEntity)event.getEntity(), EquipmentSlotType.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).getArmorPressure(EquipmentSlotType.FEET) > 0.0f && handler.isArmorReady(EquipmentSlotType.FEET)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playJetbootsParticles(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K) {
            JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(event.player);
            for (PlayerEntity player : event.player.field_70170_p.func_217369_A()) {
                JetBootsStateTracker.JetBootsState state;
                if (player.field_70122_E || !ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.FEET) || (state = tracker.getJetBootsState(player)) == null || !state.isEnabled()) continue;
                int nParticles = state.isActive() ? 5 : 1;
                Vec3d jetVec = state.shouldRotatePlayer() ? player.func_70040_Z().func_186678_a(-0.5) : IDLE_VEC;
                Vec3d feet = this.getFeetPos(player, state.shouldRotatePlayer());
                for (int i = 0; i < nParticles; ++i) {
                    player.field_70170_p.func_195594_a((IParticleData)AirParticleData.DENSE, feet.field_72450_a, feet.field_72448_b, feet.field_72449_c, jetVec.field_72450_a, jetVec.field_72448_b, jetVec.field_72449_c);
                }
            }
        }
    }

    private Vec3d getFeetPos(PlayerEntity player, boolean rotated) {
        if (!rotated) {
            return player.func_174791_d();
        }
        double midY = (player.func_226278_cu_() + player.func_174824_e((float)1.0f).field_72448_b) / 2.0;
        return player.func_174791_d().func_178787_e(player.func_70040_Z().func_186678_a(player.func_226278_cu_() - midY));
    }

    @SubscribeEvent
    public void onArmorRepair(AnvilUpdateEvent event) {
        if (event.getLeft().func_77973_b() instanceof ItemPneumaticArmor && PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON.func_199685_a_((Object)event.getRight().func_77973_b())) {
            ItemStack repairedItem = event.getLeft().func_77946_l();
            int damageRepaired = Math.min(repairedItem.func_77952_i(), event.getRight().func_190916_E() * 16);
            int ingotsToUse = (damageRepaired - 1) / 16 + 1;
            repairedItem.func_196085_b(repairedItem.func_77952_i() - damageRepaired);
            event.setOutput(repairedItem);
            event.setCost(Math.max(1, ingotsToUse / 2));
            event.setMaterialCost(ingotsToUse);
        }
    }
}

