/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.item.ItemLogisticsFrame;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlock;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class EntityLogisticsFrame
extends EntitySemiblockBase {
    public static final String NBT_INVISIBLE = "invisible";
    public static final String NBT_MATCH_NBT = "matchNBT";
    public static final String NBT_MATCH_DURABILITY = "matchDurability";
    public static final String NBT_MATCH_MODID = "matchModID";
    public static final String NBT_WHITELIST = "whitelist";
    public static final String NBT_ITEM_FILTERS = "filters";
    public static final String NBT_FLUID_FILTERS = "fluidFilters";
    private static final String NBT_SIDE = "side";
    private static final int ITEM_FILTER_SLOTS = 27;
    public static final int FLUID_FILTER_SLOTS = 9;
    private static final DataParameter<Boolean> INVISIBLE = EntityDataManager.func_187226_a(EntityLogisticsFrame.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Direction> FACING = EntityDataManager.func_187226_a(EntityLogisticsFrame.class, (IDataSerializer)DataSerializers.field_187202_l);
    private final Map<ItemStack, Integer> incomingStacks = new HashMap<ItemStack, Integer>();
    private final Map<FluidStack, Integer> incomingFluid = new IdentityHashMap<FluidStack, Integer>();
    private final ItemFilterHandler itemFilterHandler = new ItemFilterHandler(27);
    private FluidFilter fluidFilters = new FluidFilter(9);
    private boolean matchNBT = false;
    private boolean matchDurability = false;
    private boolean matchModId = false;
    private boolean whiteList = true;
    private int alpha = 255;
    public final double antiZfight;

    EntityLogisticsFrame(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.antiZfight = worldIn.field_73012_v.nextDouble() * 0.005;
    }

    public static EntityLogisticsFrame fromItemStack(World world, @Nullable PlayerEntity player, @Nonnull ItemStack stack) {
        EntitySemiblockBase logistics;
        if (stack.func_77973_b() instanceof ItemSemiBlock && (logistics = ((ItemSemiBlock)stack.func_77973_b()).createEntity(world, stack, player, BlockPos.field_177992_a)) instanceof EntityLogisticsFrame) {
            if (world.field_72995_K && stack.func_77942_o()) {
                CompoundNBT compoundnbt = logistics.func_189511_e(new CompoundNBT());
                UUID uuid = logistics.func_110124_au();
                compoundnbt.func_197643_a(stack.func_77978_p().func_74775_l("EntityTag"));
                logistics.func_184221_a(uuid);
                logistics.func_70020_e(compoundnbt);
            }
            return (EntityLogisticsFrame)logistics;
        }
        return null;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(INVISIBLE, (Object)false);
        this.func_184212_Q().func_187214_a(FACING, (Object)Direction.UP);
    }

    @Override
    public boolean canPlace(Direction facing) {
        TileEntity te = this.getCachedTileEntity();
        return te != null && (te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() || te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent());
    }

    @Override
    public abstract int getColor();

    public abstract int getPriority();

    protected abstract ContainerType<?> getContainerType();

    public boolean shouldProvideTo(int level) {
        return true;
    }

    public boolean isSemiblockInvisible() {
        return (Boolean)this.func_184212_Q().func_187225_a(INVISIBLE);
    }

    public void setSemiblockInvisible(boolean invisible) {
        this.func_184212_Q().func_187227_b(INVISIBLE, (Object)invisible);
    }

    public Direction getFacing() {
        return (Direction)this.func_184212_Q().func_187225_a(FACING);
    }

    public void setFacing(Direction facing) {
        this.func_184212_Q().func_187227_b(FACING, (Object)facing);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(boolean whiteList) {
        this.whiteList = whiteList;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public boolean isMatchDurability() {
        return this.matchDurability;
    }

    public void setMatchDurability(boolean matchDurability) {
        this.matchDurability = matchDurability;
    }

    public boolean isMatchModId() {
        return this.matchModId;
    }

    public void setMatchModId(boolean matchModId) {
        this.matchModId = matchModId;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.incomingStacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
            Iterator<Map.Entry<FluidStack, Integer>> it = this.incomingFluid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<FluidStack, Integer> entry = it.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    it.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
        } else {
            this.alpha = this.isSemiblockInvisible() && !this.playerIsHoldingLogisticItems() ? Math.max(0, this.alpha - 9) : Math.min(255, this.alpha + 9);
        }
    }

    public void informIncomingStack(ItemStack stack) {
        this.incomingStacks.put(stack, 0);
    }

    public void clearIncomingStack(ItemStack stack) {
        this.incomingStacks.remove(stack);
    }

    public void informIncomingStack(FluidStack stack) {
        this.incomingFluid.put(stack, 0);
    }

    public void clearIncomingStack(FluidStack stack) {
        this.incomingFluid.remove(stack);
    }

    public int getIncomingFluid(Fluid fluid) {
        int count = 0;
        for (FluidStack fluidStack : this.incomingFluid.keySet()) {
            if (fluidStack.getFluid() != fluid) continue;
            count += fluidStack.getAmount();
        }
        return count;
    }

    public int getIncomingItems(ItemStack stack) {
        int count = 0;
        for (ItemStack s : this.incomingStacks.keySet()) {
            if (!this.itemFilterHandler.matchOneItem(s, stack)) continue;
            count += s.func_190916_E();
        }
        return count;
    }

    public void setItemFilter(int slot, ItemStack stack) {
        this.itemFilterHandler.setStackInSlot(slot, stack);
    }

    public void setFluidFilter(int filterIndex, FluidStack stack) {
        this.fluidFilters.fluidStacks.set(filterIndex, stack);
    }

    public FluidStack getFluidFilter(int filterIndex) {
        return (FluidStack)this.fluidFilters.fluidStacks.get(filterIndex);
    }

    public ItemFilterHandler getItemFilterHandler() {
        return this.itemFilterHandler;
    }

    @Override
    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.itemFilterHandler.deserializeNBT(tag.func_74775_l(NBT_ITEM_FILTERS));
        this.fluidFilters.deserializeNBT(tag.func_74775_l(NBT_FLUID_FILTERS));
        this.setSemiblockInvisible(tag.func_74767_n(NBT_INVISIBLE));
        this.setMatchNBT(tag.func_74767_n(NBT_MATCH_NBT));
        this.setMatchDurability(tag.func_74767_n(NBT_MATCH_DURABILITY));
        this.setMatchModId(tag.func_74767_n(NBT_MATCH_MODID));
        this.setWhiteList(tag.func_74767_n(NBT_WHITELIST));
        this.setFacing(tag.func_74764_b(NBT_SIDE) ? Direction.func_82600_a((int)tag.func_74762_e(NBT_SIDE)) : Direction.UP);
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT tag) {
        tag = super.serializeNBT(tag);
        tag.func_218657_a(NBT_ITEM_FILTERS, (INBT)this.itemFilterHandler.serializeNBT());
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.serializeNBT());
        tag.func_74757_a(NBT_INVISIBLE, this.isSemiblockInvisible());
        tag.func_74757_a(NBT_MATCH_NBT, this.isMatchNBT());
        tag.func_74757_a(NBT_MATCH_DURABILITY, this.isMatchDurability());
        tag.func_74757_a(NBT_MATCH_MODID, this.isMatchModId());
        tag.func_74757_a(NBT_WHITELIST, this.isWhiteList());
        if (this.getFacing() != null) {
            tag.func_74768_a(NBT_SIDE, this.getFacing().func_176745_a());
        }
        return tag;
    }

    @Override
    public void onPlaced(PlayerEntity player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setFacing(facing);
    }

    public boolean canFilterStack() {
        return false;
    }

    boolean passesFilter(ItemStack stack) {
        return this.itemFilterHandler.isEmpty() || this.itemFilterHandler.match(stack) == this.isWhiteList();
    }

    boolean passesFilter(Fluid fluid) {
        boolean hasFilter = false;
        for (FluidStack filterStack : this.fluidFilters.fluidStacks) {
            if (filterStack.getAmount() <= 0) continue;
            if (this.matchFluids(filterStack, fluid)) {
                return true;
            }
            hasFilter = true;
        }
        return !hasFilter;
    }

    private boolean matchFluids(FluidStack filterStack, Fluid fluid) {
        return filterStack.getFluid() == fluid;
    }

    @Override
    public void addTooltip(List<ITextComponent> curInfo, PlayerEntity player, CompoundNBT tag, boolean extended) {
        NonNullList<ItemStack> drops;
        curInfo.add(PneumaticCraftUtils.xlate("gui.logistics_frame.facing", this.getFacing()));
        if (player.func_225608_bj_() && !(drops = this.getDrops()).isEmpty()) {
            ItemLogisticsFrame.addLogisticsTooltip((ItemStack)drops.get(0), player.field_70170_p, curInfo, true);
        }
    }

    @Override
    public boolean onRightClickWithConfigurator(PlayerEntity player, Direction side) {
        if (!player.field_70170_p.field_72995_K) {
            INamedContainerProvider provider = new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new ItemStack((IItemProvider)EntityLogisticsFrame.this.getDroppedItem()).func_200301_q();
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new ContainerLogistics(EntityLogisticsFrame.this.getContainerType(), i, playerInventory, EntityLogisticsFrame.this.func_145782_y());
                }
            };
            NetworkHandler.sendToPlayer(new PacketSyncSemiblock(this), (ServerPlayerEntity)player);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buffer -> buffer.func_150787_b(this.func_145782_y()));
        }
        return true;
    }

    private boolean playerIsHoldingLogisticItems() {
        PlayerEntity player = ClientUtils.getClientPlayer();
        ItemStack stack = player.func_184614_ca();
        return stack.func_77973_b() == ModItems.LOGISTICS_CONFIGURATOR.get() || stack.func_77973_b() == ModItems.LOGISTICS_DRONE.get() || stack.func_77973_b() instanceof ItemSemiBlock;
    }

    public boolean supportsBlacklisting() {
        return true;
    }

    @Override
    public void writeToBuf(PacketBuffer payload) {
        super.writeToBuf(payload);
        payload.writeBoolean(this.isSemiblockInvisible());
        payload.writeBoolean(this.whiteList);
        payload.writeBoolean(this.matchNBT);
        payload.writeBoolean(this.matchDurability);
        payload.writeBoolean(this.matchModId);
        payload.func_150787_b(this.itemFilterHandler.getSlots());
        for (int i = 0; i < this.itemFilterHandler.getSlots(); ++i) {
            payload.func_150788_a(this.itemFilterHandler.getStackInSlot(i));
        }
        this.fluidFilters.write(payload);
    }

    @Override
    public void readFromBuf(PacketBuffer payload) {
        super.readFromBuf(payload);
        this.setSemiblockInvisible(payload.readBoolean());
        this.whiteList = payload.readBoolean();
        this.matchNBT = payload.readBoolean();
        this.matchDurability = payload.readBoolean();
        this.matchModId = payload.readBoolean();
        int size = payload.func_150792_a();
        for (int i = 0; i < size; ++i) {
            this.itemFilterHandler.setStackInSlot(i, payload.func_150791_c());
        }
        this.fluidFilters = new FluidFilter(payload);
    }

    public static class FluidFilter
    implements INBTSerializable<CompoundNBT> {
        private final List<FluidStack> fluidStacks = new ArrayList<FluidStack>();

        public FluidFilter() {
        }

        FluidFilter(int size) {
            for (int i = 0; i < size; ++i) {
                this.fluidStacks.add(FluidStack.EMPTY);
            }
        }

        FluidFilter(PacketBuffer packetBuffer) {
            int size = packetBuffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                this.fluidStacks.add(packetBuffer.readFluidStack());
            }
        }

        public FluidStack get(int slot) {
            return this.fluidStacks.get(slot);
        }

        public int size() {
            return this.fluidStacks.size();
        }

        public void write(PacketBuffer packetBuffer) {
            packetBuffer.func_150787_b(this.fluidStacks.size());
            this.fluidStacks.forEach(arg_0 -> ((PacketBuffer)packetBuffer).writeFluidStack(arg_0));
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("size", this.fluidStacks.size());
            ListNBT list = new ListNBT();
            for (FluidStack f : this.fluidStacks) {
                list.add((Object)f.writeToNBT(new CompoundNBT()));
            }
            tag.func_218657_a(EntityLogisticsFrame.NBT_ITEM_FILTERS, (INBT)list);
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.fluidStacks.clear();
            int n = nbt.func_74762_e("size");
            ListNBT l = nbt.func_150295_c(EntityLogisticsFrame.NBT_ITEM_FILTERS, 10);
            for (int i = 0; i < n; ++i) {
                this.fluidStacks.add(FluidStack.loadFluidStackFromNBT((CompoundNBT)l.func_150305_b(i)));
            }
        }
    }

    public class ItemFilterHandler
    extends ItemStackHandler {
        private final List<ItemStack> filterStacks;

        ItemFilterHandler(int size) {
            super(size);
            this.filterStacks = new ArrayList<ItemStack>();
        }

        boolean match(ItemStack stack) {
            for (ItemStack filterStack : this.filterStacks) {
                if (!this.matchOneItem(filterStack, stack)) continue;
                return true;
            }
            return false;
        }

        int getMatchedCount(ItemStack stack) {
            int count = 0;
            for (ItemStack filterStack : this.filterStacks) {
                if (!this.matchOneItem(filterStack, stack)) continue;
                count += filterStack.func_190916_E();
            }
            return count;
        }

        boolean matchOneItem(ItemStack filterStack, ItemStack stack) {
            return !filterStack.func_190926_b() && PneumaticCraftUtils.doesItemMatchFilter(filterStack, stack, EntityLogisticsFrame.this.isMatchDurability(), EntityLogisticsFrame.this.isMatchNBT(), EntityLogisticsFrame.this.isMatchModId());
        }

        private void buildFilterList() {
            this.filterStacks.clear();
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                this.filterStacks.add(this.getStackInSlot(i));
            }
        }

        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.buildFilterList();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.buildFilterList();
        }

        public boolean isEmpty() {
            return this.filterStacks.isEmpty();
        }
    }
}

