/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;

public class ArmorHUDLayout
extends AuxConfigJson {
    private static final LayoutItem POWER_DEF = new LayoutItem(0.995f, 0.005f, true);
    private static final LayoutItem MESSAGE_DEF = new LayoutItem(0.005f, 0.15f, false);
    private static final LayoutItem BLOCK_TRACKER_DEF = new LayoutItem(0.995f, 0.1f, true);
    private static final LayoutItem ENTITY_TRACKER_DEF = new LayoutItem(0.995f, 0.2f, true);
    private static final LayoutItem ITEM_SEARCH_DEF = new LayoutItem(0.005f, 0.1f, false);
    private static final LayoutItem AIR_CON_DEF = new LayoutItem(0.5f, 0.005f, false);
    private static final LayoutItem JET_BOOTS_DEF = new LayoutItem(0.7f, 0.005f, true);
    public static final ArmorHUDLayout INSTANCE = new ArmorHUDLayout();
    public LayoutItem powerStat = POWER_DEF;
    public LayoutItem messageStat = MESSAGE_DEF;
    public LayoutItem blockTrackerStat = BLOCK_TRACKER_DEF;
    public LayoutItem entityTrackerStat = ENTITY_TRACKER_DEF;
    public LayoutItem itemSearchStat = ITEM_SEARCH_DEF;
    public LayoutItem airConStat = AIR_CON_DEF;
    public LayoutItem jetBootsStat = JET_BOOTS_DEF;

    private ArmorHUDLayout() {
        super(false);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("Description", "Stores the layout of Pneumatic Armor HUD elements");
        JsonObject sub = new JsonObject();
        sub.add("power", (JsonElement)this.powerStat.toJson());
        sub.add("message", (JsonElement)this.messageStat.toJson());
        sub.add("blockTracker", (JsonElement)this.blockTrackerStat.toJson());
        sub.add("entityTracker", (JsonElement)this.entityTrackerStat.toJson());
        sub.add("itemSearch", (JsonElement)this.itemSearchStat.toJson());
        sub.add("airCon", (JsonElement)this.airConStat.toJson());
        sub.add("jetBoots", (JsonElement)this.jetBootsStat.toJson());
        json.add("stats", (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        if (json.has("stats")) {
            JsonObject sub = json.getAsJsonObject("stats");
            this.powerStat = this.readLayout(sub, "power", POWER_DEF);
            this.messageStat = this.readLayout(sub, "message", MESSAGE_DEF);
            this.blockTrackerStat = this.readLayout(sub, "blockTracker", BLOCK_TRACKER_DEF);
            this.entityTrackerStat = this.readLayout(sub, "entityTracker", ENTITY_TRACKER_DEF);
            this.itemSearchStat = this.readLayout(sub, "itemSearch", ITEM_SEARCH_DEF);
            this.airConStat = this.readLayout(sub, "airCon", AIR_CON_DEF);
            this.jetBootsStat = this.readLayout(sub, "jetBoots", JET_BOOTS_DEF);
        }
    }

    private LayoutItem readLayout(JsonObject json, String name, LayoutItem def) {
        return json.has(name) ? LayoutItem.fromJson(json.get(name).getAsJsonObject()) : def;
    }

    @Override
    public String getConfigFilename() {
        return "PneumaticArmorHUDLayout";
    }

    public void updateLayout(LayoutTypes what, float x, float y, boolean leftSided) {
        LayoutItem l = new LayoutItem(x, y, leftSided);
        switch (what) {
            case POWER: {
                this.powerStat = l;
                break;
            }
            case MESSAGE: {
                this.messageStat = l;
                break;
            }
            case ENTITY_TRACKER: {
                this.entityTrackerStat = l;
                break;
            }
            case BLOCK_TRACKER: {
                this.blockTrackerStat = l;
                break;
            }
            case ITEM_SEARCH: {
                this.itemSearchStat = l;
                break;
            }
            case AIR_CON: {
                this.airConStat = l;
                break;
            }
            case JET_BOOTS: {
                this.jetBootsStat = l;
            }
        }
        try {
            this.writeToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum LayoutTypes {
        POWER,
        MESSAGE,
        ENTITY_TRACKER,
        BLOCK_TRACKER,
        ITEM_SEARCH,
        AIR_CON,
        JET_BOOTS;

    }

    public static class LayoutItem {
        private final float x;
        private final float y;
        private final boolean leftSided;

        LayoutItem(float x, float y, boolean leftSided) {
            this.x = x;
            this.y = y;
            this.leftSided = leftSided;
        }

        LayoutItem(int screenX, int screenY, int x, int y, boolean leftSided) {
            this.x = (float)x / (float)screenX;
            this.y = (float)y / (float)screenY;
            this.leftSided = leftSided;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public boolean isLeftSided() {
            return this.leftSided;
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)Float.valueOf(this.x));
            obj.addProperty("y", (Number)Float.valueOf(this.y));
            obj.addProperty("leftSided", Boolean.valueOf(this.leftSided));
            return obj;
        }

        static LayoutItem fromJson(JsonObject obj) {
            return new LayoutItem(obj.get("x").getAsFloat(), obj.get("y").getAsFloat(), obj.get("leftSided").getAsBoolean());
        }
    }
}

