/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.client.util.RangeLines;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.tileentity.TileEntityHeatSink;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModuleAirGrate
extends TubeModule {
    private int grateRange;
    private boolean vacuum;
    private final Set<TileEntityHeatSink> heatSinks = new HashSet<TileEntityHeatSink>();
    private final RangeLines rangeLines = new RangeLines(0x5500FF00);
    private boolean renderRangeLines;
    private EntityFilter entityFilter = null;
    private TileEntity adjacentInsertionTE = null;
    private Direction adjacentInsertionSide;
    private final Map<BlockPos, Boolean> traceabilityCache = new HashMap<BlockPos, Boolean>();

    public ModuleAirGrate(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    private int getRange() {
        float range = this.pressureTube.getPressure() * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range *= -4.0f;
        }
        return (int)range;
    }

    public int getGrateRange() {
        return this.grateRange;
    }

    public RangeLines getRangeLines() {
        return this.rangeLines;
    }

    @Override
    public double getWidth() {
        return 16.0;
    }

    @Override
    public void update() {
        super.update();
        World world = this.pressureTube.func_145831_w();
        BlockPos pos = this.pressureTube.func_174877_v();
        if ((world.func_82737_E() & 0x1FL) == 0L) {
            this.traceabilityCache.clear();
        }
        if (!world.field_72995_K) {
            int oldGrateRange = this.grateRange;
            this.grateRange = this.getRange();
            if (oldGrateRange != this.grateRange) {
                this.sendDescriptionPacket();
            }
            this.coolHeatSinks();
        } else {
            if (this.renderRangeLines) {
                this.rangeLines.startRendering(this.grateRange);
                this.renderRangeLines = false;
            }
            this.rangeLines.tick(world.field_73012_v);
        }
        this.pushEntities(world, pos, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
    }

    private AxisAlignedBB getAffectedAABB() {
        return new AxisAlignedBB(this.pressureTube.func_174877_v().func_177967_a(this.getDirection(), this.grateRange + 1)).func_186662_g((double)this.grateRange);
    }

    private void pushEntities(World world, BlockPos pos, Vec3d tileVec) {
        AxisAlignedBB bbBox = this.getAffectedAABB();
        List entities = world.func_175647_a(Entity.class, bbBox, (Predicate)this.entityFilter);
        double d0 = this.grateRange * 3;
        int entitiesMoved = 0;
        for (Entity entity : entities) {
            double z;
            double d4;
            double d5;
            if (!entity.field_70170_p.field_72995_K && entity instanceof ItemEntity && entity.func_70089_S() && entity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.0) {
                this.tryItemInsertion((ItemEntity)entity);
                continue;
            }
            if (this.ignoreEntity(entity) || !this.rayTraceOK(entity, tileVec)) continue;
            double x = (entity.func_226277_ct_() - (double)pos.func_177958_n() - 0.5) / d0;
            double y = (entity.func_226278_cu_() + (double)entity.func_70047_e() - (double)pos.func_177956_o() - 0.5) / d0;
            BlockPos entityPos = entity.func_180425_c();
            if (!Block.func_220056_d((BlockState)world.func_180495_p(entityPos), (IBlockReader)world, (BlockPos)entityPos, (Direction)Direction.UP) && !world.func_175623_d(entityPos)) {
                y -= 0.15;
            }
            if (!((d5 = 1.0 - (d4 = Math.sqrt(x * x + y * y + (z = (entity.func_226281_cx_() - (double)pos.func_177952_p() - 0.5) / d0) * z))) > 0.0)) continue;
            d5 *= d5;
            if (this.vacuum) {
                d5 *= -1.0;
            }
            entity.func_213315_a(MoverType.SELF, new Vec3d(x * d5, y * d5, z * d5));
            ++entitiesMoved;
            if (!world.field_72995_K || !(world.field_73012_v.nextDouble() < 0.2)) continue;
            if (this.vacuum) {
                world.func_195594_a((IParticleData)AirParticleData.DENSE, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), -x, -y, -z);
                continue;
            }
            world.func_195594_a((IParticleData)AirParticleData.DENSE, (double)pos.func_177958_n() + 0.5 + (double)this.getDirection().func_82601_c(), (double)pos.func_177956_o() + 0.5 + (double)this.getDirection().func_96559_d(), (double)pos.func_177952_p() + 0.5 + (double)this.getDirection().func_82599_e(), x, y, z);
        }
        if (!world.field_72995_K) {
            this.pressureTube.addAir(-entitiesMoved * 2);
        }
    }

    private boolean ignoreEntity(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_184812_l_() || entity.func_225608_bj_();
        }
        return false;
    }

    private boolean rayTraceOK(Entity entity, Vec3d tileVec) {
        BlockPos pos = new BlockPos(entity.func_174824_e(0.0f));
        return this.traceabilityCache.computeIfAbsent(pos, k -> {
            Vec3d entityVec = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
            RayTraceContext ctx = new RayTraceContext(entityVec, tileVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
            BlockRayTraceResult trace = entity.func_130014_f_().func_217299_a(ctx);
            return trace != null && trace.func_216350_a().equals((Object)this.pressureTube.func_174877_v());
        });
    }

    private void tryItemInsertion(ItemEntity entity) {
        if (this.getAdjacentInventory() != null) {
            ItemStack stack = entity.func_92059_d();
            ItemStack excess = IOHelper.insert(this.getAdjacentInventory(), stack, this.adjacentInsertionSide, false);
            if (excess.func_190926_b()) {
                entity.func_70106_y();
            } else {
                entity.func_92058_a(excess);
            }
        }
    }

    private TileEntity getAdjacentInventory() {
        if (this.adjacentInsertionTE != null && !this.adjacentInsertionTE.func_145837_r()) {
            return this.adjacentInsertionTE;
        }
        this.adjacentInsertionTE = null;
        for (Direction dir : Direction.field_199792_n) {
            TileEntity inv = this.pressureTube.func_145831_w().func_175625_s(this.pressureTube.func_174877_v().func_177972_a(dir));
            if (inv == null || !inv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).isPresent()) continue;
            this.adjacentInsertionTE = inv;
            this.adjacentInsertionSide = dir.func_176734_d();
            break;
        }
        return this.adjacentInsertionTE;
    }

    private void coolHeatSinks() {
        if (this.grateRange > 2) {
            int curTeIndex = (int)(this.pressureTube.func_145831_w().func_82737_E() % 27L);
            BlockPos curPos = this.pressureTube.func_174877_v().func_177967_a(this.dir, 2).func_177982_a(-1 + curTeIndex % 3, -1 + curTeIndex / 3 % 3, -1 + curTeIndex / 9 % 3);
            TileEntity te = this.pressureTube.func_145831_w().func_175625_s(curPos);
            if (te instanceof TileEntityHeatSink) {
                this.heatSinks.add((TileEntityHeatSink)te);
            }
            Iterator<TileEntityHeatSink> iterator = this.heatSinks.iterator();
            while (iterator.hasNext()) {
                TileEntityHeatSink heatSink = iterator.next();
                if (heatSink.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
            }
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.func_74767_n("vacuum");
        this.grateRange = tag.func_74762_e("grateRange");
        String f = tag.func_74779_i("entityFilter");
        this.entityFilter = f.isEmpty() ? null : EntityFilter.fromString(f);
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("vacuum", this.vacuum);
        tag.func_74768_a("grateRange", this.grateRange);
        tag.func_74778_a("entityFilter", this.entityFilter == null ? "" : this.entityFilter.toString());
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        String txt = this.grateRange == 0 ? "Idle" : (this.vacuum ? "Attracting" : "Repelling");
        curInfo.add(new StringTextComponent("Status: ").func_150258_a(txt).func_211708_a(TextFormatting.WHITE));
        curInfo.add(new StringTextComponent("Range: ").func_150258_a(this.grateRange + " blocks").func_211708_a(TextFormatting.WHITE));
        if (this.entityFilter != null) {
            curInfo.add(new StringTextComponent("Entity Filter: \"").func_150258_a(this.entityFilter.toString()).func_150258_a("\"").func_211708_a(TextFormatting.WHITE));
        }
    }

    @Override
    public boolean hasGui() {
        return this.upgraded;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAffectedAABB();
    }

    public String getEntityFilterString() {
        return this.entityFilter == null ? "" : this.entityFilter.toString();
    }

    public void setEntityFilter(String filter) {
        this.entityFilter = EntityFilter.fromString(filter);
    }

    @Override
    public boolean onActivated(PlayerEntity player, Hand hand) {
        if (player.field_70170_p.field_72995_K && !this.rangeLines.shouldRender()) {
            this.renderRangeLines = true;
        }
        return super.onActivated(player, hand);
    }

    @Override
    public void onPlaced() {
        this.renderRangeLines = true;
    }
}

