/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoorBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockPneumaticDoor
extends BlockPneumaticCraft {
    public static final BooleanProperty TOP_DOOR = BooleanProperty.func_177716_a((String)"top_door");

    public BlockPneumaticDoor() {
        super(ModBlocks.defaultProps());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TOP_DOOR});
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static boolean isTopDoor(BlockState state) {
        return state.func_177230_c() == ModBlocks.PNEUMATIC_DOOR.get() && (Boolean)state.func_177229_b((IProperty)TOP_DOOR) != false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.calculateVoxelShape(state, world, pos, 13);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.calculateVoxelShape(state, world, pos, 15);
    }

    private VoxelShape calculateVoxelShape(BlockState state, IBlockReader world, BlockPos pos, int thickness) {
        float xMin = 0.001f;
        float zMin = 0.001f;
        float xMax = 0.999f;
        float zMax = 0.999f;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPneumaticDoor) {
            Direction rotation = this.getRotation(state);
            TileEntityPneumaticDoor door = (TileEntityPneumaticDoor)te;
            float t = (float)thickness / 16.0f;
            float rads = (float)Math.toRadians(door.rotationAngle);
            float cosinus = t - MathHelper.func_76126_a((float)rads) * t;
            float sinus = t - MathHelper.func_76134_b((float)rads) * t;
            if (door.rightGoing) {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case WEST: {
                        xMin = cosinus;
                        zMin = sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMin = sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMax = 1.0f - sinus;
                    }
                }
            } else {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMin = sinus;
                        break;
                    }
                    case WEST: {
                        xMin = 0.001f + cosinus;
                        zMax = 0.999f - sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMin = sinus;
                    }
                }
            }
        }
        boolean topDoor = (Boolean)state.func_177229_b((IProperty)TOP_DOOR);
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)xMin, topDoor ? -1.0 : 0.0, (double)zMin, (double)xMax, topDoor ? 1.0 : 2.0, (double)zMax));
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPneumaticDoor.class;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(down);
        if (((Boolean)state.func_177229_b((IProperty)TOP_DOOR)).booleanValue()) {
            return belowState.func_177230_c() == this;
        }
        return Block.func_220056_d((BlockState)belowState, (IBlockReader)world, (BlockPos)down, (Direction)Direction.UP);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack par6ItemStack) {
        super.func_180633_a(world, pos, state, par5EntityLiving, par6ItemStack);
        world.func_180501_a(pos.func_177972_a(Direction.UP), (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPneumaticDoor) {
            TileEntityPneumaticDoor teDoor = (TileEntityPneumaticDoor)te;
            BlockPos top = pos.func_177984_a();
            if (world.func_180495_p(top.func_177972_a(this.getRotation(state).func_176735_f())).func_177230_c() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = true;
            } else if (world.func_180495_p(top.func_177972_a(this.getRotation(state).func_176746_e())).func_177230_c() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = false;
            }
            TileEntity topHalf = world.func_175625_s(top);
            if (topHalf instanceof TileEntityPneumaticDoor) {
                ((TileEntityPneumaticDoor)topHalf).rightGoing = teDoor.rightGoing;
                ((TileEntityPneumaticDoor)topHalf).color = teDoor.color;
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos posDown = pos.func_177977_b();
        BlockPos posUp = pos.func_177984_a();
        if (BlockPneumaticDoor.isTopDoor(state) && worldIn.func_180495_p(posDown).func_177230_c() == this) {
            worldIn.func_217377_a(posDown, false);
        } else if (!BlockPneumaticDoor.isTopDoor(state) && worldIn.func_180495_p(posUp).func_177230_c() == this) {
            worldIn.func_217377_a(posUp, false);
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction face, Hand hand) {
        BlockState state = world.func_180495_p(pos);
        if (BlockPneumaticDoor.isTopDoor(state)) {
            return this.onWrenched(world, player, pos.func_177972_a(Direction.DOWN), face, hand);
        }
        if (player != null && player.func_225608_bj_()) {
            if (!player.func_184812_l_()) {
                TileEntity te = world.func_175625_s(pos);
                Block.func_220059_a((BlockState)world.func_180495_p(pos), (World)world, (BlockPos)pos, (TileEntity)te);
                IFluidState ifluidstate = world.func_204610_c(pos);
                world.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
                ifluidstate = world.func_204610_c(pos.func_177984_a());
                world.func_180501_a(pos.func_177984_a(), ifluidstate.func_206883_i(), 3);
            }
        } else {
            super.onWrenched(world, player, pos, face, hand);
            BlockState newState = world.func_180495_p(pos);
            world.func_180501_a(pos.func_177972_a(Direction.UP), (BlockState)newState.func_206870_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntityPneumaticDoorBase doorBase = this.getDoorBase(world, pos);
        if (!world.field_72995_K) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)player.func_184586_b(hand));
            if (dyeColor != null) {
                TileEntityPneumaticDoor teDoor;
                TileEntity te = world.func_175625_s(BlockPneumaticDoor.isTopDoor(state) ? pos.func_177977_b() : pos);
                if (te instanceof TileEntityPneumaticDoor && (teDoor = (TileEntityPneumaticDoor)te).setColor(dyeColor) && PNCConfig.Common.General.useUpDyesWhenColoring) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
            } else if (doorBase != null && doorBase.redstoneMode == 2 && doorBase.getPressure() >= doorBase.getMinWorkingPressure() && hand == Hand.MAIN_HAND) {
                doorBase.setOpening(!doorBase.isOpening());
                doorBase.setNeighborOpening(doorBase.isOpening());
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) > 0;
        if (!powered) {
            powered = world.func_175687_A(pos.func_177972_a(BlockPneumaticDoor.isTopDoor(state) ? Direction.DOWN : Direction.UP)) > 0;
        }
        TileEntityPneumaticDoorBase doorBase = this.getDoorBase(world, pos);
        if (!world.field_72995_K && doorBase != null && doorBase.getPressure() >= 2.0f && powered != doorBase.wasPowered) {
            doorBase.wasPowered = powered;
            doorBase.setOpening(powered);
        }
    }

    private TileEntityPneumaticDoorBase getDoorBase(World world, BlockPos pos) {
        TileEntityPneumaticDoorBase doorBase;
        TileEntityPneumaticDoorBase doorBase2;
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return null;
        }
        if (!BlockPneumaticDoor.isTopDoor(world.func_180495_p(pos))) {
            return this.getDoorBase(world, pos.func_177972_a(Direction.UP));
        }
        Direction dir = this.getRotation((IBlockReader)world, pos);
        if (dir.func_176740_k() == Direction.Axis.Y) {
            return null;
        }
        TileEntity te1 = world.func_175625_s(pos.func_177972_a(dir.func_176746_e()));
        if (te1 instanceof TileEntityPneumaticDoorBase && (doorBase2 = (TileEntityPneumaticDoorBase)te1).getRotation() == dir.func_176735_f()) {
            return doorBase2;
        }
        TileEntity te2 = world.func_175625_s(pos.func_177972_a(dir.func_176735_f()));
        if (te2 instanceof TileEntityPneumaticDoorBase && (doorBase = (TileEntityPneumaticDoorBase)te2).getRotation() == dir.func_176746_e()) {
            return doorBase;
        }
        return null;
    }

    public static class ItemBlockPneumaticDoor
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockPneumaticDoor(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            CompoundNBT tag;
            if (tintIndex == 0 && (tag = stack.func_179543_a("BlockEntityTag")) != null && tag.func_150297_b("color", 3)) {
                int color = tag.func_74762_e("color");
                return DyeColor.func_196056_a((int)color).getColorValue();
            }
            return -1;
        }
    }
}

