/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.ai.DistanceEntitySorter;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class DroneEntityAIPickupItems
extends Goal {
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase itemPickupWidget;
    private ItemEntity curPickingUpEntity;
    private final DistanceEntitySorter theNearestAttackableTargetSorter;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.NORTH, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.DOWN};

    public DroneEntityAIPickupItems(IDroneBase drone, ProgWidgetAreaItemBase progWidgetPickupItem) {
        this.drone = drone;
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        this.itemPickupWidget = progWidgetPickupItem;
        this.theNearestAttackableTargetSorter = new DistanceEntitySorter(drone);
    }

    public boolean func_75250_a() {
        List<Entity> pickableItems = this.itemPickupWidget.getEntitiesInArea(this.drone.world(), entity -> entity instanceof ItemEntity && entity.func_70089_S());
        if (pickableItems.isEmpty()) {
            this.drone.addDebugEntry("gui.progWidget.itemPickup.debug.noItems");
            return false;
        }
        pickableItems.sort(this.theNearestAttackableTargetSorter);
        for (Entity ent : pickableItems) {
            ItemStack stack = ((ItemEntity)ent).func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                if (IOHelper.insert(this.drone, stack, null, true).func_190926_b()) {
                    return this.tryMoveToItem(ent);
                }
                this.drone.addDebugEntry("gui.progWidget.inventoryImport.debug.filledToMax");
                continue;
            }
            this.drone.addDebugEntry("gui.progWidget.itemPickup.debug.itemNotValid");
        }
        return false;
    }

    private boolean tryMoveToItem(Entity ent) {
        if (!this.drone.isBlockValidPathfindBlock(ent.func_180425_c())) {
            for (Direction d : DIRECTIONS) {
                BlockPos pos2 = ent.func_180425_c().func_177972_a(d);
                if (!this.drone.isBlockValidPathfindBlock(pos2) || !this.drone.getPathNavigator().moveToXYZ((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5)) continue;
                this.curPickingUpEntity = (ItemEntity)ent;
                return true;
            }
        } else if (this.drone.getPathNavigator().moveToEntity(ent)) {
            this.curPickingUpEntity = (ItemEntity)ent;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.curPickingUpEntity.func_70089_S()) {
            return false;
        }
        if (this.curPickingUpEntity.func_174791_d().func_72436_e(this.drone.getDronePos()) < 4.0) {
            ItemStack stack = this.curPickingUpEntity.func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, this.curPickingUpEntity);
            }
            return false;
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    static void tryPickupItem(IDrone drone, ItemEntity itemEntity) {
        ItemStack remainder;
        ItemStack stack = itemEntity.func_92059_d();
        int stackSize = stack.func_190916_E();
        int collected = stackSize - (remainder = IOHelper.insert(drone, stack, Direction.UP, false)).func_190916_E();
        if (collected > 0) {
            drone.onItemPickupEvent(itemEntity, collected);
        }
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        } else if (collected > 0) {
            itemEntity.func_92058_a(remainder);
        }
    }
}

