/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiInventorySearcher;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetAreaShow;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiProgWidgetArea
extends GuiProgWidgetAreaShow<ProgWidgetArea> {
    private GuiInventorySearcher invSearchGui;
    private int pointSearched;
    private WidgetComboBox variableField1;
    private WidgetComboBox variableField2;
    private final List<AreaType> allAreaTypes = ProgWidgetArea.getAllAreaTypes();
    private final List<Pair<AreaType.AreaTypeWidget, Widget>> areaTypeValueWidgets = new ArrayList<Pair<AreaType.AreaTypeWidget, Widget>>();
    private final List<Widget> areaTypeStaticWidgets = new ArrayList<Widget>();

    public GuiProgWidgetArea(ProgWidgetArea widget, GuiProgrammer guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 256;
    }

    @Override
    public void init() {
        super.init();
        boolean advancedMode = PNCConfig.Client.programmerDifficulty == IProgWidget.WidgetDifficulty.ADVANCED;
        WidgetButtonExtended gpsButton1 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 6 : 55), this.guiTop + 30, 20, 20, "", b -> this.openInvSearchGUI(0)).setRenderStacks(new ItemStack((IItemProvider)ModItems.GPS_TOOL.get())).setTooltipText(I18n.func_135052_a((String)"gui.progWidget.area.selectGPS1", (Object[])new Object[0]));
        this.addButton((Widget)gpsButton1);
        WidgetButtonExtended gpsButton2 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 133 : 182), this.guiTop + 30, 20, 20, "", b -> this.openInvSearchGUI(1)).setRenderStacks(new ItemStack((IItemProvider)ModItems.GPS_TOOL.get())).setTooltipText(I18n.func_135052_a((String)"gui.progWidget.area.selectGPS2", (Object[])new Object[0]));
        this.addButton((Widget)gpsButton2);
        this.font.getClass();
        this.variableField1 = new WidgetComboBox(this.font, this.guiLeft + 28, this.guiTop + 35, 88, 9 + 1);
        this.font.getClass();
        this.variableField2 = new WidgetComboBox(this.font, this.guiLeft + 155, this.guiTop + 35, 88, 9 + 1);
        Set<String> variables = this.guiProgrammer == null ? Collections.emptySet() : ((TileEntityProgrammer)this.guiProgrammer.te).getAllVariables();
        this.variableField1.setElements(variables);
        this.variableField2.setElements(variables);
        this.variableField1.func_146180_a(((ProgWidgetArea)this.progWidget).getCoord1Variable());
        this.variableField2.func_146180_a(((ProgWidgetArea)this.progWidget).getCoord2Variable());
        if (advancedMode) {
            this.addButton((Widget)this.variableField1);
            this.addButton((Widget)this.variableField2);
        }
        this.addLabel(I18n.func_135052_a((String)"gui.progWidget.area.type", (Object[])new Object[0]), this.guiLeft + 8, this.guiTop + 88);
        int widgetsPerColumn = 5;
        ArrayList<WidgetRadioButton> radioButtons = new ArrayList<WidgetRadioButton>();
        for (int i = 0; i < this.allAreaTypes.size(); ++i) {
            AreaType areaType = this.allAreaTypes.get(i);
            WidgetRadioButton radioButton = new WidgetRadioButton(this.guiLeft + 5 + i / 5 * 80, this.guiTop + 100 + i % 5 * 12, -12566464, areaType.getName(), b -> {
                ((ProgWidgetArea)this.progWidget).type = areaType;
                this.switchToWidgets(areaType);
            });
            if (((ProgWidgetArea)this.progWidget).type.getClass() == areaType.getClass()) {
                this.allAreaTypes.set(i, ((ProgWidgetArea)this.progWidget).type);
                radioButton.checked = true;
            }
            this.addButton(radioButton);
            radioButtons.add(radioButton);
            radioButton.otherChoices = radioButtons;
        }
        this.switchToWidgets(((ProgWidgetArea)this.progWidget).type);
        if (this.invSearchGui != null) {
            BlockPos searchPos = this.getSearchedGPSPos();
            if (this.pointSearched == 0) {
                ((ProgWidgetArea)this.progWidget).x1 = searchPos.func_177958_n();
                ((ProgWidgetArea)this.progWidget).y1 = searchPos.func_177956_o();
                ((ProgWidgetArea)this.progWidget).z1 = searchPos.func_177952_p();
            } else {
                ((ProgWidgetArea)this.progWidget).x2 = searchPos.func_177958_n();
                ((ProgWidgetArea)this.progWidget).y2 = searchPos.func_177956_o();
                ((ProgWidgetArea)this.progWidget).z2 = searchPos.func_177952_p();
            }
        }
        String l1 = "P1: " + TextFormatting.DARK_BLUE + this.formatPos(((ProgWidgetArea)this.progWidget).x1, ((ProgWidgetArea)this.progWidget).y1, ((ProgWidgetArea)this.progWidget).z1);
        this.addLabel(l1, this.guiLeft + 8, this.guiTop + 20);
        String l2 = "P2: " + TextFormatting.DARK_BLUE + this.formatPos(((ProgWidgetArea)this.progWidget).x2, ((ProgWidgetArea)this.progWidget).y2, ((ProgWidgetArea)this.progWidget).z2);
        this.addLabel(l2, this.guiLeft + 133, this.guiTop + 20);
    }

    private String formatPos(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? "-" : String.format("[ %d, %d, %d ]", x, y, z);
    }

    private BlockPos getSearchedGPSPos() {
        List<BlockPos> posList;
        ItemStack stack = this.invSearchGui.getSearchStack();
        if (stack.func_77973_b() instanceof IPositionProvider && !(posList = ((IPositionProvider)stack.func_77973_b()).getStoredPositions(ClientUtils.getClientWorld(), stack)).isEmpty() && posList.get(0) != null) {
            return posList.get(0);
        }
        return BlockPos.field_177992_a;
    }

    private void openInvSearchGUI(int which) {
        ItemStack gpsStack = new ItemStack((IItemProvider)ModItems.GPS_TOOL.get());
        if (which == 0) {
            ItemGPSTool.setGPSLocation(gpsStack, new BlockPos(((ProgWidgetArea)this.progWidget).x1, ((ProgWidgetArea)this.progWidget).y1, ((ProgWidgetArea)this.progWidget).z1));
        } else {
            ItemGPSTool.setGPSLocation(gpsStack, new BlockPos(((ProgWidgetArea)this.progWidget).x2, ((ProgWidgetArea)this.progWidget).y2, ((ProgWidgetArea)this.progWidget).z2));
        }
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.INVENTORY_SEARCHER.get()), (ITextComponent)new StringTextComponent("Inventory Searcher (GPS)"));
        if (this.minecraft.field_71462_r instanceof GuiInventorySearcher) {
            this.invSearchGui = (GuiInventorySearcher)this.minecraft.field_71462_r;
            this.invSearchGui.setStackPredicate(itemStack -> itemStack.func_77973_b() instanceof IPositionProvider);
            this.invSearchGui.setSearchStack(ItemGPSTool.getGPSLocation(gpsStack) != null ? gpsStack : ItemStack.field_190927_a);
        }
        this.pointSearched = which;
    }

    private void switchToWidgets(AreaType type) {
        this.saveWidgets();
        this.areaTypeValueWidgets.forEach(p -> this.removeWidget((Widget)p.getRight()));
        this.areaTypeStaticWidgets.forEach(this::removeWidget);
        this.areaTypeValueWidgets.clear();
        this.areaTypeStaticWidgets.clear();
        int curY = this.guiTop + 100;
        int x = this.guiLeft + 150;
        ArrayList<AreaType.AreaTypeWidget> atWidgets = new ArrayList<AreaType.AreaTypeWidget>();
        type.addUIWidgets(atWidgets);
        for (AreaType.AreaTypeWidget areaTypeWidget : atWidgets) {
            WidgetLabel titleWidget = new WidgetLabel(x, curY, I18n.func_135052_a((String)areaTypeWidget.title, (Object[])new Object[0]));
            this.addButton(titleWidget);
            this.areaTypeStaticWidgets.add(titleWidget);
            this.font.getClass();
            curY += 9 + 1;
            if (areaTypeWidget instanceof AreaType.AreaTypeWidgetInteger) {
                AreaType.AreaTypeWidgetInteger intWidget = (AreaType.AreaTypeWidgetInteger)areaTypeWidget;
                this.font.getClass();
                WidgetTextFieldNumber intField = new WidgetTextFieldNumber(this.font, x, curY, 40, 9 + 1);
                intField.setValue(intWidget.readAction.get().intValue());
                this.addButton((Widget)intField);
                this.areaTypeValueWidgets.add((Pair<AreaType.AreaTypeWidget, Widget>)new ImmutablePair((Object)areaTypeWidget, (Object)intField));
                this.font.getClass();
                curY += 9 + 20;
                continue;
            }
            if (areaTypeWidget instanceof AreaType.AreaTypeWidgetEnum) {
                AreaType.AreaTypeWidgetEnum enumWidget = (AreaType.AreaTypeWidgetEnum)areaTypeWidget;
                this.font.getClass();
                WidgetComboBox enumCbb = new WidgetComboBox(this.font, x, curY, 80, 9 + 1).setFixedOptions();
                enumCbb.setElements(this.getEnumNames(enumWidget.enumClass));
                enumCbb.func_146180_a(((Enum)enumWidget.readAction.get()).toString());
                this.addButton((Widget)enumCbb);
                this.areaTypeValueWidgets.add((Pair<AreaType.AreaTypeWidget, Widget>)new ImmutablePair((Object)areaTypeWidget, (Object)enumCbb));
                this.font.getClass();
                curY += 9 + 20;
                continue;
            }
            throw new IllegalStateException("Invalid widget type: " + areaTypeWidget.getClass());
        }
    }

    private void saveWidgets() {
        for (Pair<AreaType.AreaTypeWidget, Widget> entry : this.areaTypeValueWidgets) {
            AreaType.AreaTypeWidget widget = (AreaType.AreaTypeWidget)entry.getLeft();
            Widget guiWidget = (Widget)entry.getRight();
            if (widget instanceof AreaType.AreaTypeWidgetInteger) {
                AreaType.AreaTypeWidgetInteger intWidget = (AreaType.AreaTypeWidgetInteger)widget;
                intWidget.writeAction.accept(((WidgetTextFieldNumber)guiWidget).getValue());
                continue;
            }
            if (!(widget instanceof AreaType.AreaTypeWidgetEnum)) continue;
            AreaType.AreaTypeWidgetEnum enumWidget = (AreaType.AreaTypeWidgetEnum)widget;
            WidgetComboBox cbb = (WidgetComboBox)guiWidget;
            List<String> enumNames = this.getEnumNames(enumWidget.enumClass);
            E[] enumValues = enumWidget.enumClass.getEnumConstants();
            Object selectedValue = enumValues[enumNames.indexOf(cbb.func_146179_b())];
            enumWidget.writeAction.accept((Enum)selectedValue);
        }
    }

    private List<String> getEnumNames(Class<?> enumClass) {
        ?[] enumValues = enumClass.getEnumConstants();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (Object enumValue : enumValues) {
            enumNames.add(enumValue.toString());
        }
        return enumNames;
    }

    @Override
    protected void previewArea(WidgetCheckBox button) {
        super.previewArea(button);
        this.saveWidgets();
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_WIDGET_AREA;
    }

    @Override
    public void onClose() {
        ((ProgWidgetArea)this.progWidget).setCoord1Variable(this.variableField1.func_146179_b());
        ((ProgWidgetArea)this.progWidget).setCoord2Variable(this.variableField2.func_146179_b());
        this.saveWidgets();
        super.onClose();
    }
}

