/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.containers;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.modules.containers.AbstractPipeContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractPipeGui<T extends AbstractPipeContainer<?>>
extends ContainerScreen<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/pipe.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ItemStack[] lastItems;

    public AbstractPipeGui(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.lastItems = new ItemStack[((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots()];
        this.field_146999_f = 176;
        this.field_147000_g = 203;
    }

    protected void init() {
        super.init();
        this.initTabs();
    }

    public void tick() {
        super.tick();
        boolean changed = false;
        for (int i = 0; i < ((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots(); ++i) {
            ItemStack stack = ((AbstractPipeContainer)this.field_147002_h).tile.modules.getStackInSlot(i);
            if (stack == this.lastItems[i]) continue;
            this.lastItems[i] = stack;
            changed = true;
        }
        if (changed) {
            this.initTabs();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        for (Widget widget : this.buttons) {
            if (!widget.isHovered()) continue;
            widget.renderToolTip(mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 38.0f, 0x404040);
        for (Tab tab : this.tabs) {
            tab.drawForeground(mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r + 32, 0, 0, 176, 171);
        for (Tab tab : this.tabs) {
            tab.draw();
        }
        for (Slot slot : ((AbstractPipeContainer)this.field_147002_h).field_75151_b) {
            if (slot.field_75224_c == this.field_213127_e) continue;
            this.blit(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 176, 62, 18, 18);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        for (Tab tab : this.tabs) {
            if (!tab.onClicked(x, y, button)) continue;
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    private void initTabs() {
        this.tabs.clear();
        this.tabs.add(new Tab(new ItemStack((IItemProvider)Registry.pipeBlock), null, 0, -1));
        for (int i = 0; i < ((AbstractPipeContainer)this.field_147002_h).tile.modules.getSlots(); ++i) {
            IModule module;
            ItemStack stack = ((AbstractPipeContainer)this.field_147002_h).tile.modules.getStackInSlot(i);
            if (stack.func_190926_b() || !(module = (IModule)stack.func_77973_b()).hasContainer(stack, ((AbstractPipeContainer)this.field_147002_h).tile)) continue;
            this.tabs.add(new Tab(stack, module, this.tabs.size(), i));
        }
    }

    private class Tab {
        private final ItemStack moduleStack;
        private final IModule module;
        private final int index;
        private final int x;
        private final int y;

        public Tab(ItemStack moduleStack, IModule module, int tabIndex, int index) {
            this.moduleStack = moduleStack;
            this.module = module;
            this.index = index;
            this.x = AbstractPipeGui.this.field_147003_i + 5 + tabIndex * 28;
            this.y = AbstractPipeGui.this.field_147009_r;
        }

        private void draw() {
            int y = 2;
            int v = 0;
            int height = 30;
            int itemOffset = 9;
            if (this.module == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).module) {
                y = 0;
                v = 30;
                height = 32;
                itemOffset = 7;
            }
            AbstractPipeGui.this.blit(this.x, this.y + y, 176, v, 28, height);
            AbstractPipeGui.this.itemRenderer.func_175042_a(this.moduleStack, this.x + 6, this.y + itemOffset);
            AbstractPipeGui.this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        }

        private void drawForeground(int mouseX, int mouseY) {
            if (mouseX < this.x || mouseY < this.y || mouseX >= this.x + 28 || mouseY >= this.y + 32) {
                return;
            }
            AbstractPipeGui.this.renderTooltip(this.moduleStack.func_200301_q().func_150254_d(), mouseX - AbstractPipeGui.this.field_147003_i, mouseY - AbstractPipeGui.this.field_147009_r);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (this.module == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).module) {
                return false;
            }
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 28) || mouseY >= (double)(this.y + 32)) {
                return false;
            }
            PacketHandler.sendToServer(new PacketButton(((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).field_147002_h).tile.func_174877_v(), PacketButton.ButtonResult.PIPE_TAB, this.index));
            AbstractPipeGui.this.getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
    }
}

