/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketItemEnterPipe {
    private BlockPos tilePos;
    private CompoundNBT item;

    public PacketItemEnterPipe(BlockPos tilePos, PipeItem item) {
        this.tilePos = tilePos;
        this.item = item.serializeNBT();
    }

    private PacketItemEnterPipe() {
    }

    public static PacketItemEnterPipe fromBytes(PacketBuffer buf) {
        PacketItemEnterPipe client = new PacketItemEnterPipe();
        client.tilePos = buf.func_179259_c();
        client.item = buf.func_150793_b();
        return client;
    }

    public static void toBytes(PacketItemEnterPipe packet, PacketBuffer buf) {
        buf.func_179255_a(packet.tilePos);
        buf.func_150786_a(packet.item);
    }

    public static void onMessage(final PacketItemEnterPipe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71441_e == null) {
                    return;
                }
                PipeItem item = new PipeItem(message.item);
                PipeTileEntity pipe = Utility.getTileEntity(PipeTileEntity.class, (World)mc.field_71441_e, message.tilePos);
                if (pipe != null) {
                    pipe.getItems().add(item);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

