/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.modules.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.util.TriConsumer;

public class PacketButton {
    private BlockPos pos;
    private ButtonResult result;
    private int[] data;

    public PacketButton(BlockPos pos, ButtonResult result, int ... data) {
        this.pos = pos;
        this.result = result;
        this.data = data;
    }

    private PacketButton() {
    }

    public static PacketButton fromBytes(PacketBuffer buf) {
        PacketButton packet = new PacketButton();
        packet.pos = buf.func_179259_c();
        packet.result = ButtonResult.values()[buf.readByte()];
        packet.data = buf.func_186863_b();
        return packet;
    }

    public static void toBytes(PacketButton packet, PacketBuffer buf) {
        buf.func_179255_a(packet.pos);
        buf.writeByte(packet.result.ordinal());
        buf.func_186875_a(packet.data);
    }

    public static void onMessage(final PacketButton message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ((PacketButton)message).result.action.accept((Object)message.pos, (Object)message.data, (Object)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        PacketHandler.sendToServer(new PacketButton(pos, result, data));
        result.action.accept((Object)pos, (Object)data, (Object)Minecraft.func_71410_x().field_71439_g);
    }

    public static enum ButtonResult {
        PIPE_TAB((TriConsumer<BlockPos, int[], PlayerEntity>)((TriConsumer)(pos, data, player) -> {
            final PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, player.field_70170_p, pos);
            if (data[0] < 0) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos);
            } else {
                final ItemStack stack = tile.modules.getStackInSlot(data[0]);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider((int[])data){
                    final /* synthetic */ int[] val$data;
                    {
                        this.val$data = nArray;
                    }

                    public ITextComponent func_145748_c_() {
                        return stack.func_200301_q();
                    }

                    @Nullable
                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return ((IModule)stack.func_77973_b()).getContainer(stack, tile, windowId, inv, player, this.val$data[0]);
                    }
                }, buf -> {
                    buf.func_179255_a(pos);
                    buf.writeInt(data[0]);
                });
            }
        })),
        FILTER_CHANGE((TriConsumer<BlockPos, int[], PlayerEntity>)((TriConsumer)(pos, data, player) -> {
            ItemFilter.IFilteredContainer container = (ItemFilter.IFilteredContainer)player.field_71070_bA;
            ItemFilter filter = container.getFilter();
            filter.onButtonPacket(data[0]);
        })),
        STACK_SIZE_MODULE_BUTTON((TriConsumer<BlockPos, int[], PlayerEntity>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.field_71070_bA;
            StackSizeModuleItem.setLimitToMaxStackSize(container.moduleStack, !StackSizeModuleItem.getLimitToMaxStackSize(container.moduleStack));
        })),
        STACK_SIZE_AMOUNT((TriConsumer<BlockPos, int[], PlayerEntity>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.field_71070_bA;
            StackSizeModuleItem.setMaxStackSize(container.moduleStack, data[0]);
        }));

        public final TriConsumer<BlockPos, int[], PlayerEntity> action;

        private ButtonResult(TriConsumer<BlockPos, int[], PlayerEntity> action) {
            this.action = action;
        }
    }
}

