/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class NetworkLocation {
    public final BlockPos pipePos;
    public final Direction direction;
    public final BlockPos pos;
    public final IItemHandler handler;
    private Map<Integer, ItemStack> items;

    public NetworkLocation(BlockPos pipePos, Direction direction, IItemHandler handler) {
        this.pipePos = pipePos;
        this.direction = direction;
        this.pos = pipePos.func_177972_a(direction);
        this.handler = handler;
    }

    public void addItem(int slot, ItemStack stack) {
        if (this.items == null) {
            this.items = new HashMap<Integer, ItemStack>();
        }
        this.items.put(slot, stack);
    }

    public int getStackSlot(ItemStack stack) {
        if (this.isEmpty()) {
            return -1;
        }
        for (Map.Entry<Integer, ItemStack> entry : this.items.entrySet()) {
            if (!entry.getValue().func_77969_a(stack)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public int getItemAmount(ItemStack stack) {
        return this.items.values().stream().filter(i -> i.func_77969_a(stack)).mapToInt(ItemStack::func_190916_E).sum();
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public String toString() {
        return this.items.values().toString();
    }
}

