/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.entities;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class PipeFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> AMOUNT = EntityDataManager.func_187226_a(PipeFrameEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, World world) {
        super(type, world);
    }

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, World world, BlockPos pos, Direction dir) {
        this(type, world);
        this.field_174861_a = pos;
        this.func_174859_a(dir);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AMOUNT, (Object)-1);
    }

    public void func_70071_h_() {
        ItemStack stack;
        BlockPos node;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 40 != 0) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.field_70170_p);
        BlockPos attached = PipeFrameEntity.getAttachedPipe(this.field_70170_p, this.field_174861_a, this.field_174860_b);
        if (attached != null && (node = network.getNodeFromPipe(attached)) != null && !(stack = this.func_82335_i()).func_190926_b()) {
            List<NetworkLocation> items = network.getOrderedNetworkItems(node);
            int amount = items.stream().mapToInt(i -> i.getItemAmount(stack)).sum();
            this.field_70180_af.func_187227_b(AMOUNT, (Object)amount);
            return;
        }
        this.field_70180_af.func_187227_b(AMOUNT, (Object)-1);
    }

    public boolean func_70518_d() {
        return super.func_70518_d() && PipeFrameEntity.canPlace(this.field_70170_p, this.field_174861_a, this.field_174860_b);
    }

    private static BlockPos getAttachedPipe(World world, BlockPos pos, Direction direction) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos offset = pos.func_177967_a(direction.func_176734_d(), i);
            BlockState state = world.func_180495_p(offset);
            if (!(state.func_177230_c() instanceof PipeBlock)) continue;
            return offset;
        }
        return null;
    }

    public static boolean canPlace(World world, BlockPos pos, Direction direction) {
        return PipeFrameEntity.getAttachedPipe(world, pos, direction) != null;
    }

    public int getAmount() {
        return (Integer)this.field_70180_af.func_187225_a(AMOUNT);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && !this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.dropItemOrSelf(source.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    private void dropItemOrSelf(@Nullable Entity entityIn, boolean b) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (entityIn == null) {
                this.func_82335_i().func_82842_a(null);
            }
        } else {
            ItemStack itemstack = this.func_82335_i();
            this.func_82334_a(ItemStack.field_190927_a);
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    itemstack.func_82842_a(null);
                    return;
                }
            }
            if (b) {
                this.func_199703_a((IItemProvider)Registry.pipeFrameItem);
            }
            if (!itemstack.func_190926_b()) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_82842_a(null);
                this.func_199701_a_(itemstack);
            }
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (this.func_82335_i().func_190926_b()) {
            return super.func_184230_a(player, hand);
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Registry.pipeFrameItem);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179255_a(this.field_174861_a);
        buffer.writeInt(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.field_174861_a = additionalData.func_179259_c();
        this.func_174859_a(Direction.values()[additionalData.readInt()]);
    }
}

