/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public final class Utility {
    public static <T extends TileEntity> T getTileEntity(Class<T> type, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static void dropInventory(TileEntity tile, IItemHandler inventory) {
        BlockPos pos = tile.func_174877_v();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)tile.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    public static Direction getDirectionFromOffset(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.func_177973_b((Vec3i)other);
        return Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
    }

    public static void addTooltip(String name, List<ITextComponent> tooltip) {
        if (Screen.hasShiftDown()) {
            String[] content;
            for (String s : content = I18n.func_135052_a((String)("info.prettypipes." + name), (Object[])new Object[0]).split("\n")) {
                tooltip.add(new StringTextComponent(s).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
        } else {
            tooltip.add(new TranslationTextComponent("info.prettypipes.shift", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)));
        }
    }
}

