/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.entities.PipeFrameEntity;
import de.ellpeck.prettypipes.entities.PipeFrameRenderer;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.items.WrenchItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeRenderer;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.modules.FilterModifierModule;
import de.ellpeck.prettypipes.pipe.modules.LowPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SpeedModuleItem;
import de.ellpeck.prettypipes.pipe.modules.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.containers.MainPipeGui;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleGui;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleItem;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleGui;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleItem;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleGui;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleGui;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static final ItemGroup GROUP = new ItemGroup("prettypipes"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)wrenchItem);
        }
    };
    @CapabilityInject(value=PipeNetwork.class)
    public static Capability<PipeNetwork> pipeNetworkCapability;
    public static Item wrenchItem;
    public static Item pipeFrameItem;
    public static Block pipeBlock;
    public static TileEntityType<PipeTileEntity> pipeTileEntity;
    public static EntityType<PipeFrameEntity> pipeFrameEntity;
    public static ContainerType<MainPipeContainer> pipeContainer;
    public static ContainerType<ExtractionModuleContainer> extractionModuleContainer;
    public static ContainerType<FilterModuleContainer> filterModuleContainer;
    public static ContainerType<RetrievalModuleContainer> retrievalModuleContainer;
    public static ContainerType<StackSizeModuleContainer> stackSizeModuleContainer;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{pipeBlock = (Block)new PipeBlock().setRegistryName("pipe")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        wrenchItem = (Item)new WrenchItem().setRegistryName("wrench");
        registry.registerAll((IForgeRegistryEntry[])new Item[]{wrenchItem, (Item)new Item(new Item.Properties().func_200916_a(GROUP)).setRegistryName("blank_module"), pipeFrameItem = (Item)new PipeFrameItem().setRegistryName("pipe_frame")});
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("extraction_module", ExtractionModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("filter_module", FilterModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("speed_module", SpeedModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("low_priority_module", LowPriorityModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("retrieval_module", RetrievalModuleItem::new));
        registry.register((IForgeRegistryEntry)new StackSizeModuleItem("stack_size_module"));
        registry.registerAll((IForgeRegistryEntry[])Arrays.stream(FilterModifierModule.Type.values()).map(t -> new FilterModifierModule(t.name().toLowerCase(Locale.ROOT) + "_filter_modifier", (FilterModifierModule.Type)((Object)t))).toArray(Item[]::new));
        ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("prettypipes")).forEach(b -> registry.register(new BlockItem(b, new Item.Properties().func_200916_a(GROUP)).setRegistryName(b.getRegistryName())));
    }

    @SubscribeEvent
    public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{pipeTileEntity = (TileEntityType)TileEntityType.Builder.func_223042_a(PipeTileEntity::new, (Block[])new Block[]{pipeBlock}).func_206865_a(null).setRegistryName("pipe")});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{pipeFrameEntity = (EntityType)EntityType.Builder.func_220322_a(PipeFrameEntity::new, (EntityClassification)EntityClassification.MISC).func_206830_a("pipe_frame").setRegistryName("pipe_frame")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ContainerType[] containerTypeArray = new ContainerType[5];
        containerTypeArray[0] = pipeContainer = (ContainerType)IForgeContainerType.create((windowId, inv, data) -> new MainPipeContainer(pipeContainer, windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("pipe");
        extractionModuleContainer = Registry.createPipeContainer("extraction_module");
        containerTypeArray[1] = extractionModuleContainer;
        filterModuleContainer = Registry.createPipeContainer("filter_module");
        containerTypeArray[2] = filterModuleContainer;
        retrievalModuleContainer = Registry.createPipeContainer("retrieval_module");
        containerTypeArray[3] = retrievalModuleContainer;
        stackSizeModuleContainer = Registry.createPipeContainer("stack_size_module");
        containerTypeArray[4] = stackSizeModuleContainer;
        event.getRegistry().registerAll((IForgeRegistryEntry[])containerTypeArray);
    }

    private static <T extends AbstractPipeContainer<?>> ContainerType<T> createPipeContainer(String name) {
        return (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
            PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, inv.field_70458_d.field_70170_p, data.func_179259_c());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.func_77973_b()).getContainer(moduleStack, tile, windowId, inv, inv.field_70458_d, moduleIndex);
        }).setRegistryName(name);
    }

    private static Item[] createTieredModule(String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        ArrayList<IForgeRegistryEntry> items = new ArrayList<IForgeRegistryEntry>();
        for (ModuleTier tier : ModuleTier.values()) {
            items.add(item.apply(name, tier).setRegistryName(tier.name().toLowerCase(Locale.ROOT) + "_" + name));
        }
        return items.toArray(new Item[0]);
    }

    public static void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PipeNetwork.class, (Capability.IStorage)new Capability.IStorage<PipeNetwork>(){

            @Nullable
            public INBT writeNBT(Capability<PipeNetwork> capability, PipeNetwork instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<PipeNetwork> capability, PipeNetwork instance, Direction side, INBT nbt) {
            }
        }, () -> null);
        PacketHandler.setup();
    }

    public static final class Client {
        public static void setup(FMLClientSetupEvent event) {
            RenderTypeLookup.setRenderLayer((Block)pipeBlock, (RenderType)RenderType.func_228643_e_());
            ClientRegistry.bindTileEntityRenderer(pipeTileEntity, PipeRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(pipeFrameEntity, PipeFrameRenderer::new);
            ScreenManager.func_216911_a(pipeContainer, MainPipeGui::new);
            ScreenManager.func_216911_a(extractionModuleContainer, ExtractionModuleGui::new);
            ScreenManager.func_216911_a(filterModuleContainer, FilterModuleGui::new);
            ScreenManager.func_216911_a(retrievalModuleContainer, RetrievalModuleGui::new);
            ScreenManager.func_216911_a(stackSizeModuleContainer, StackSizeModuleGui::new);
        }
    }
}

