/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonManualLink
extends Button {
    public String localized;
    @Nullable
    public ManualInstance.ManualLink link;
    ManualScreen gui;
    public List<GuiButtonManualLink> otherParts = ImmutableList.of();

    public GuiButtonManualLink(ManualScreen gui, int x, int y, int w, int h, @Nullable ManualInstance.ManualLink link, String localized) {
        super(x, y, w, h, "", btn -> {
            if (link != null) {
                link.changePage(gui, true);
            }
        });
        this.gui = gui;
        this.link = link;
        this.localized = localized;
        if (gui.manual.improveReadability()) {
            this.localized = TextFormatting.BOLD + localized;
        }
    }

    public void render(int mx, int my, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = this.isHovered = mx >= this.x && my >= this.y && mx < this.x + this.width && my < this.y + this.height;
        if (this.isHovered) {
            this.drawHovered(mc, true, mx, my);
            for (GuiButtonManualLink btn : this.otherParts) {
                if (btn == this) continue;
                btn.drawHovered(mc, false, mx, my);
            }
        }
    }

    private void drawHovered(Minecraft mc, boolean mouse, int mx, int my) {
        FontRenderer font = this.gui.manual.fontRenderer();
        font.func_211126_b(this.localized, (float)this.x, (float)this.y, this.gui.manual.getHighlightColour());
        List<String> tooltip = this.link != null ? Collections.singletonList(this.gui.manual.formatLink(this.link)) : Collections.singletonList("Invalid link");
        this.gui.renderTooltip(tooltip, mx + 8, my + 4, font);
    }
}

