/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ManualUtils {
    private static final String THIS = "this";
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ResourceLocation) {
            return ManualUtils.isInTag(stack, (ResourceLocation)o);
        }
        if (o instanceof ItemStack) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)o), (ItemStack)stack)) {
                return false;
            }
            if (((ItemStack)o).func_77942_o()) {
                return ((ItemStack)o).func_77978_p().equals((Object)stack.func_77978_p());
            }
            return true;
        }
        return false;
    }

    public static boolean isInTag(ItemStack stack, ResourceLocation tag) {
        Tag itemTag = ItemTags.func_199903_a().func_199910_a(tag);
        if (itemTag != null && itemTag.func_199685_a_((Object)stack.func_77973_b())) {
            return true;
        }
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(tag);
        return blockTag != null && blockTag.func_199685_a_((Object)Block.func_149634_a((Item)stack.func_77973_b()));
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        Tag t = (Tag)ItemTags.func_199903_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        Tag t = (Tag)BlockTags.func_199896_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return ManualUtils.isNonemptyBlockTag(name) || ManualUtils.isNonemptyItemTag(name);
    }

    public static String getTitleForNode(Tree.AbstractNode<ResourceLocation, ManualEntry> node, ManualInstance inst) {
        if (node.isLeaf()) {
            return inst.formatEntryName(node.getLeafData().getTitle());
        }
        return inst.formatCategoryName(node.getNodeData());
    }

    public static void drawTexturedRect(ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ManualUtils.drawTexturedRect(new MatrixStack(), (IRenderTypeBuffer)buffers, texture, x, y, w, h, uv);
        buffers.func_228461_a_();
    }

    public static void drawTexturedRect(MatrixStack transform, IRenderTypeBuffer buffers, ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        IVertexBuilder buffer = buffers.getBuffer(IERenderTypes.getGui(texture));
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, (float)x, (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[0], uv[3]).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + w), (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[1], uv[3]).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + w), (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[1], uv[2]).func_181675_d();
        buffer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[0], uv[2]).func_181675_d();
    }

    public static <T> List<T> getPrimitiveSpellingCorrections(String query, Iterable<T> valid, int maxDistance, Function<T, String> getTitle) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (T node : valid) {
            String s2 = getTitle.apply(node);
            if (s2 == null || s2.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s2) >= maxDistance) continue;
            ret.add(node);
        }
        ret.sort(Comparator.comparingInt(s -> ManualUtils.getSpellingDistanceBetweenStrings(query, (String)getTitle.apply(s))));
        return ret;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase(Locale.ENGLISH);
        target = target.toLowerCase(Locale.ENGLISH);
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += Math.abs(targetWords[iWord].length() - queryWords[iWord].length());
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static List<String[]> prepareEntryForLinks(String[] entryA) {
        int start;
        String format = TextFormatting.ITALIC.toString() + TextFormatting.UNDERLINE.toString();
        String entry = entryA[0];
        ArrayList<String[]> repList = new ArrayList<String[]>();
        int linksAdded = 0;
        while ((start = entry.indexOf("<link")) >= 0 && linksAdded < 50) {
            ++linksAdded;
            int end = entry.indexOf(">", start);
            String rep = entry.substring(start, end + 1);
            String[] segment = rep.substring(0, rep.length() - 1).split(";");
            if (segment.length < 3) break;
            String anchor = segment.length > 3 ? segment[3] : "start";
            String[] resultParts = segment[2].split("(?<= )");
            StringBuilder result = new StringBuilder();
            ArrayList<String> forCompleteLink = new ArrayList<String>(3 * resultParts.length);
            for (String resultPart : resultParts) {
                String part = format + resultPart;
                forCompleteLink.add(part);
                forCompleteLink.add(segment[1]);
                forCompleteLink.add(anchor);
                result.append(part);
            }
            repList.add(forCompleteLink.toArray(new String[0]));
            entry = entry.substring(0, start) + result + TextFormatting.RESET.toString() + entry.substring(end + 1);
        }
        entryA[0] = entry;
        return repList;
    }

    public static void addLinks(ManualEntry entry, ManualInstance manual, ManualScreen gui, List<String> text, int x, int y, List<Button> pageButtons, List<String[]> repList) {
        for (String[] repComplete : repList) {
            String[] rep = new String[3];
            ArrayList<GuiButtonManualLink> parts = new ArrayList<GuiButtonManualLink>();
            block3: for (int i = 0; i < repComplete.length / 3; ++i) {
                System.arraycopy(repComplete, 3 * i, rep, 0, 3);
                for (int line = 0; line < text.size(); ++line) {
                    ManualInstance.ManualLink link;
                    String s = text.get(line);
                    int start = s.indexOf(rep[0].trim());
                    if (start < 0) continue;
                    String linkText = rep[0];
                    if (!s.substring(start).startsWith(rep[0])) {
                        linkText = linkText.trim();
                    }
                    int bx = manual.fontRenderer().func_78256_a(s.substring(0, start));
                    manual.fontRenderer().getClass();
                    int by = line * 9;
                    ResourceLocation bkey = THIS.equals(rep[1]) ? entry.getLocation() : ManualUtils.getLocationForManual(rep[1], manual);
                    int bw = manual.fontRenderer().func_78256_a(linkText);
                    String bAnchor = "start";
                    int bOffset = 0;
                    try {
                        if (rep[2].contains("+")) {
                            int plus = rep[2].indexOf(43);
                            bAnchor = rep[2].substring(0, plus);
                            bOffset = Integer.parseInt(rep[2].substring(plus + 1));
                        } else {
                            bAnchor = rep[2];
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    ManualEntry bEntry = manual.getEntry(bkey);
                    if (bEntry != null && bEntry.hasAnchor(bAnchor)) {
                        link = new ManualInstance.ManualLink(bEntry, bAnchor, bOffset);
                    } else {
                        if (bEntry == null) {
                            IELogger.logger.error("Unknown manual entry: {} (link from {})", (Object)bkey, (Object)entry.getLocation());
                        } else if (!bEntry.hasAnchor(bAnchor)) {
                            IELogger.logger.error("Unknown anchor {} in entry {} (link from {})", (Object)bAnchor, (Object)bkey, (Object)entry.getLocation());
                        }
                        link = null;
                    }
                    manual.fontRenderer().getClass();
                    GuiButtonManualLink btn = new GuiButtonManualLink(gui, x + bx, y + by, bw, (int)(9.0 * 1.5), link, linkText);
                    parts.add(btn);
                    pageButtons.add(btn);
                    text.set(line, s);
                    continue block3;
                }
            }
            for (GuiButtonManualLink btn : parts) {
                btn.otherParts = parts;
            }
        }
    }

    public static String attemptStringTranslation(String tranlationKey, String arg) {
        String translated;
        String untranslated = String.format(tranlationKey, arg);
        if (!untranslated.equals(translated = I18n.func_135052_a((String)untranslated, (Object[])new Object[0]))) {
            return translated;
        }
        return arg;
    }

    public static Tessellator tes() {
        return Tessellator.func_178181_a();
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(ResourceLocation path) {
        ManualUtils.mc().func_110434_K().func_110577_a(path);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static ItemRenderer renderItem() {
        return ManualUtils.mc().func_175599_af();
    }

    public static void drawSplitString(FontRenderer fontRenderer, List<String> text, int x, int y, int colour) {
        for (String s : text) {
            fontRenderer.func_211126_b(s, (float)x, (float)y, colour);
            fontRenderer.getClass();
            y += 9;
        }
    }

    private static void parseSpecial(JsonObject obj, String anchor, TextSplitter splitter, ManualInstance instance) {
        String type = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
        int offset = JSONUtils.func_151208_a((JsonObject)obj, (String)"offset", (int)0);
        ResourceLocation resLoc = ManualUtils.getLocationForManual(type, instance);
        Function<JsonObject, SpecialManualElement> createElement = instance.getElementFactory(resLoc);
        splitter.addSpecialPage(anchor, offset, createElement.apply(obj));
    }

    public static void parseSpecials(JsonObject data, TextSplitter splitter, ManualInstance instance) {
        for (Map.Entry entry : data.entrySet()) {
            JsonElement currData = (JsonElement)entry.getValue();
            if (currData.isJsonObject()) {
                ManualUtils.parseSpecial(currData.getAsJsonObject(), (String)entry.getKey(), splitter, instance);
                continue;
            }
            for (JsonElement inner : currData.getAsJsonArray()) {
                ManualUtils.parseSpecial(inner.getAsJsonObject(), (String)entry.getKey(), splitter, instance);
            }
        }
    }

    public static ResourceLocation getLocationForManual(String s, ManualInstance instance) {
        if (s.indexOf(58) >= 0) {
            return new ResourceLocation(s);
        }
        return new ResourceLocation(instance.getDefaultResourceDomain(), s);
    }

    public static boolean isNumber(JsonObject main, String name) {
        return main.has(name) && main.get(name).isJsonPrimitive() && main.get(name).getAsJsonPrimitive().isNumber();
    }

    @Nullable
    public static PositionedItemStack parsePosItemStack(JsonElement ele) {
        JsonObject json = ele.getAsJsonObject();
        if (!ManualUtils.isNumber(json, "x")) {
            return null;
        }
        int x = JSONUtils.func_151203_m((JsonObject)json, (String)"x");
        if (!ManualUtils.isNumber(json, "y")) {
            return null;
        }
        int y = JSONUtils.func_151203_m((JsonObject)json, (String)"y");
        if (JSONUtils.func_151205_a((JsonObject)json, (String)"item")) {
            return new PositionedItemStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true), x, y);
        }
        if (JSONUtils.func_151202_d((JsonObject)json, (String)"stacks")) {
            JsonArray arr = json.getAsJsonArray("stacks");
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(arr.size());
            for (JsonElement stack : arr) {
                stacks.add(CraftingHelper.getItemStack((JsonObject)stack.getAsJsonObject(), (boolean)true));
            }
            return new PositionedItemStack(stacks, x, y);
        }
        try {
            return new PositionedItemStack(CraftingHelper.getIngredient((JsonElement)json), x, y);
        }
        catch (JsonSyntaxException xcp) {
            return null;
        }
    }

    public static ItemStack getItemStackFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonPrimitive()) {
            ResourceLocation itemName = ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return CraftingHelper.getItemStack((JsonObject)jsonEle.getAsJsonObject(), (boolean)true);
    }

    public static Object getRecipeObjFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonObject()) {
            JsonObject json = jsonEle.getAsJsonObject();
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"recipe")) {
                return ManualUtils.getLocationForManual(JSONUtils.func_151200_h((JsonObject)json, (String)"recipe"), m);
            }
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"orename")) {
                return json.get("orename").getAsString();
            }
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"item")) {
                return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            }
        } else {
            if (jsonEle.isJsonArray()) {
                JsonArray json = jsonEle.getAsJsonArray();
                PositionedItemStack[] stacks = new PositionedItemStack[json.size()];
                for (int i = 0; i < json.size(); ++i) {
                    PositionedItemStack posStack = ManualUtils.parsePosItemStack(json.get(i));
                    if (posStack == null) {
                        throw new RuntimeException("Failed to load positional item stack from " + json.get(i));
                    }
                    stacks[i] = posStack;
                }
                return stacks;
            }
            if (jsonEle.isJsonPrimitive() && jsonEle.getAsJsonPrimitive().isString()) {
                return ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            }
        }
        throw new RuntimeException("Could not find recipe for " + jsonEle);
    }

    public static boolean listStack(String search, ItemStack stack) {
        return stack.func_200301_q().func_150254_d().toLowerCase(Locale.ENGLISH).contains(search);
    }
}

