/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class ManualElementTable
extends SpecialManualElements {
    private String[][] table;
    private String[][] localizedTable;
    private int[] bars;
    private boolean horizontalBars = false;
    private int height;
    private int[] textOff;

    public ManualElementTable(ManualInstance manual, String[][] table, boolean horizontalBars) {
        super(manual);
        this.table = table;
        this.horizontalBars = horizontalBars;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        super.onOpened(gui, x, y, pageButtons);
        try {
            if (this.table != null) {
                int i;
                this.localizedTable = new String[this.table.length][];
                this.bars = new int[1];
                for (int i2 = 0; i2 < this.table.length; ++i2) {
                    int j;
                    this.localizedTable[i2] = new String[this.table[i2].length];
                    for (j = 0; j < this.table[i2].length; ++j) {
                        if (this.table[i2][j] == null) continue;
                        this.localizedTable[i2][j] = I18n.func_135052_a((String)this.table[i2][j], (Object[])new Object[0]);
                    }
                    if (this.table[i2].length - 1 > this.bars.length) {
                        int[] newBars = new int[this.table[i2].length - 1];
                        System.arraycopy(this.bars, 0, newBars, 0, this.bars.length);
                        this.bars = newBars;
                    }
                    for (j = 0; j < this.table[i2].length - 1; ++j) {
                        int fl = this.manual.fontRenderer().func_78256_a(this.localizedTable[i2][j]);
                        if (fl <= this.bars[j]) continue;
                        this.bars[j] = fl;
                    }
                }
                this.textOff = new int[this.bars != null ? this.bars.length : 0];
                if (this.bars != null) {
                    int xx = x;
                    for (i = 0; i < this.bars.length; ++i) {
                        this.textOff[i] = xx += this.bars[i] + 8;
                    }
                }
                int yOff = 0;
                for (i = 0; i < this.localizedTable.length; ++i) {
                    if (this.localizedTable[i] == null) continue;
                    for (int j = 0; j < this.localizedTable[i].length; ++j) {
                        if (this.localizedTable[i][j] == null) continue;
                        int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] - x : 0));
                        int l = this.manual.fontRenderer().func_78271_c(this.localizedTable[i][j], w).size();
                        if (j == 0) continue;
                        this.manual.fontRenderer().getClass();
                        yOff += l * (9 + 1);
                    }
                }
                this.height = yOff;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(ManualScreen gui, int x, int y, int mx, int my) {
        if (this.localizedTable != null) {
            int col = this.manual.getHighlightColour() | 0xFF000000;
            AbstractGui.fill((int)x, (int)(y - 2), (int)(x + 120), (int)(y - 1), (int)col);
            int yOff = 0;
            for (String[] line : this.localizedTable) {
                if (line == null) continue;
                int height = 0;
                for (int j = 0; j < line.length; ++j) {
                    if (line[j] == null) continue;
                    int xx = this.textOff.length > 0 && j > 0 ? this.textOff[j - 1] : x;
                    int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] - x : 0));
                    this.manual.fontRenderer().func_78279_b(line[j], xx, y + yOff, w, this.manual.getTextColour());
                    int lines = this.manual.fontRenderer().func_78271_c(line[j], w).size();
                    if (lines <= height) continue;
                    height = lines;
                }
                if (this.horizontalBars) {
                    float scale = 0.5f;
                    RenderSystem.scalef((float)1.0f, (float)scale, (float)1.0f);
                    this.manual.fontRenderer().getClass();
                    int barHeight = (int)((float)(y + yOff + height * 9) / scale);
                    AbstractGui.fill((int)x, (int)barHeight, (int)(x + 120), (int)(barHeight + 1), (int)(this.manual.getTextColour() | 0xFF000000));
                    RenderSystem.scalef((float)1.0f, (float)(1.0f / scale), (float)1.0f);
                }
                this.manual.fontRenderer().getClass();
                yOff += height * (9 + 1);
            }
            if (this.bars != null) {
                for (int i = 0; i < this.bars.length; ++i) {
                    AbstractGui.fill((int)(this.textOff[i] - 4), (int)(y - 4), (int)(this.textOff[i] - 3), (int)(y + yOff), (int)col);
                }
            }
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.height;
    }

    @Override
    public boolean isAbove() {
        return false;
    }
}

