/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEWorldGen {
    public static Map<String, ConfiguredFeature<?, ?>> features = new HashMap();
    public static Map<String, ConfiguredFeature<?, ?>> retroFeatures = new HashMap();
    public static List<ResourceLocation> oreDimBlacklist = new ArrayList<ResourceLocation>();
    public static Set<String> retrogenOres = new HashSet<String>();
    public static final Map<DimensionType, List<ChunkPos>> retrogenChunks = new HashMap<DimensionType, List<ChunkPos>>();
    int indexToRemove = 0;
    private static CountRangeInIEDimensions COUNT_RANGE_IE;

    public static void addOreGen(String name, BlockState state, int maxVeinSize, int minY, int maxY, int chunkOccurence) {
        OreFeatureConfig cfg = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, state, maxVeinSize);
        ConfiguredFeature feature = new ConfiguredFeature(Feature.field_202290_aj, (IFeatureConfig)cfg).func_227228_a_(new ConfiguredPlacement((Placement)COUNT_RANGE_IE, (IPlacementConfig)new CountRangeConfig(chunkOccurence, minY, minY, maxY)));
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        }
        features.put(name, feature);
        ConfiguredFeature retroFeature = new ConfiguredFeature(IEContent.ORE_RETROGEN, (IFeatureConfig)cfg).func_227228_a_(new ConfiguredPlacement((Placement)COUNT_RANGE_IE, (IPlacementConfig)new CountRangeConfig(chunkOccurence, minY, minY, maxY)));
        retroFeatures.put(name, retroFeature);
    }

    public void generateOres(Random random, int chunkX, int chunkZ, ServerWorld world, boolean newGeneration) {
        block4: {
            if (oreDimBlacklist.contains(world.func_201675_m().func_186058_p().getRegistryName())) break block4;
            if (newGeneration) {
                for (Map.Entry<String, ConfiguredFeature<?, ?>> gen : features.entrySet()) {
                    gen.getValue().func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), random, new BlockPos(16 * chunkX, 0, 16 * chunkZ));
                }
            } else {
                for (Map.Entry<String, ConfiguredFeature<?, ?>> gen : retroFeatures.entrySet()) {
                    if (!retrogenOres.contains("retrogen_" + gen.getKey())) continue;
                    gen.getValue().func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), random, new BlockPos(16 * chunkX, 0, 16 * chunkZ));
                }
            }
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        CompoundNBT nbt = new CompoundNBT();
        event.getData().func_218657_a("ImmersiveEngineering", (INBT)nbt);
        nbt.func_74757_a((String)IEConfig.ORES.retrogen_key.get(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkLoad(ChunkDataEvent.Load event) {
        if (event.getChunk().func_201589_g() == ChunkStatus.field_222617_m) {
            DimensionType dimension = event.getChunk().getWorldForge().func_201675_m().func_186058_p();
            if (!event.getData().func_74775_l("ImmersiveEngineering").func_74764_b((String)IEConfig.ORES.retrogen_key.get()) && !retrogenOres.isEmpty()) {
                if (((Boolean)IEConfig.ORES.retrogen_log_flagChunk.get()).booleanValue()) {
                    IELogger.info("Chunk " + event.getChunk().func_76632_l() + " has been flagged for Ore RetroGeneration by IE.");
                }
                Map<DimensionType, List<ChunkPos>> map = retrogenChunks;
                synchronized (map) {
                    retrogenChunks.computeIfAbsent(dimension, d -> new ArrayList()).add(event.getChunk().func_76632_l());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        int remaining;
        if (event.side == LogicalSide.CLIENT || event.phase == TickEvent.Phase.START || !(event.world instanceof ServerWorld)) {
            return;
        }
        DimensionType dimension = event.world.func_201675_m().func_186058_p();
        int counter = 0;
        Map<DimensionType, List<ChunkPos>> map = retrogenChunks;
        synchronized (map) {
            List<ChunkPos> chunks = retrogenChunks.get(dimension);
            if (chunks != null && chunks.size() > 0) {
                if (this.indexToRemove >= chunks.size()) {
                    this.indexToRemove = 0;
                }
                for (int i = 0; i < 2 && this.indexToRemove < chunks.size() && chunks.size() > 0; ++i) {
                    ChunkPos loc = chunks.get(this.indexToRemove);
                    if (event.world.func_217354_b(loc.field_77276_a, loc.field_77275_b)) {
                        long worldSeed = event.world.func_72905_C();
                        Random fmlRandom = new Random(worldSeed);
                        long xSeed = fmlRandom.nextLong() >> 3;
                        long zSeed = fmlRandom.nextLong() >> 3;
                        fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                        this.generateOres(fmlRandom, loc.field_77276_a, loc.field_77275_b, (ServerWorld)event.world, false);
                        ++counter;
                        chunks.remove(this.indexToRemove);
                        continue;
                    }
                    ++this.indexToRemove;
                }
            }
            remaining = chunks == null ? 0 : chunks.size();
        }
        if (counter > 0 && ((Boolean)IEConfig.ORES.retrogen_log_remaining.get()).booleanValue()) {
            IELogger.info("Retrogen was performed on " + counter + " Chunks, " + remaining + " chunks remaining");
        }
    }

    @SubscribeEvent
    public static void registerPlacements(RegistryEvent.Register<Placement<?>> ev) {
        COUNT_RANGE_IE = new CountRangeInIEDimensions(CountRangeConfig::func_214733_a);
        COUNT_RANGE_IE.setRegistryName("immersiveengineering", "count_range_in_ie_dimensions");
        ev.getRegistry().register((IForgeRegistryEntry)COUNT_RANGE_IE);
    }

    private static class CountRangeInIEDimensions
    extends Placement<CountRangeConfig> {
        private final CountRange countRange;

        public CountRangeInIEDimensions(Function<Dynamic<?>, ? extends CountRangeConfig> configFactoryIn) {
            super(configFactoryIn);
            this.countRange = new CountRange(configFactoryIn);
        }

        @Nonnull
        public Stream<BlockPos> getPositions(@Nonnull IWorld worldIn, @Nonnull ChunkGenerator<? extends GenerationSettings> generatorIn, @Nonnull Random random, @Nonnull CountRangeConfig configIn, @Nonnull BlockPos pos) {
            DimensionType d = worldIn.func_201675_m().func_186058_p();
            if (!oreDimBlacklist.contains(d.getRegistryName())) {
                return this.countRange.func_212848_a_(worldIn, generatorIn, random, (IPlacementConfig)configIn, pos);
            }
            return Stream.empty();
        }
    }
}

