/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class IEInventoryHandler
implements IItemHandlerModifiable {
    int slots;
    IIEInventory inv;
    int slotOffset;
    boolean[] canInsert;
    boolean[] canExtract;

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean[] canInsert, boolean[] canExtract) {
        this.slots = slots;
        this.inv = inventory;
        this.slotOffset = slotOffset;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    public IEInventoryHandler(int slots, IIEInventory inventory) {
        this(slots, inventory, 0, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = true;
            this.canExtract[i] = true;
        }
    }

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean canInsert, boolean canExtract) {
        this(slots, inventory, slotOffset, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = canInsert;
            this.canExtract[i] = canExtract;
        }
    }

    public IEInventoryHandler blockInsert(int ... blockedSlots) {
        for (int s : blockedSlots) {
            this.canInsert[s] = false;
        }
        return this;
    }

    public int getSlots() {
        return this.slots;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inv.getInventory().get(this.slotOffset + slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canInsert[slot] || stack.func_190926_b()) {
            return stack;
        }
        if (!this.inv.isStackValid(this.slotOffset + slot, stack = stack.func_77946_l())) {
            return stack;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = (ItemStack)this.inv.getInventory().get(offsetSlot);
        if (currentStack.func_190926_b()) {
            int accepted = Math.min(stack.func_77976_d(), this.inv.getSlotLimit(offsetSlot));
            if (accepted < stack.func_190916_E()) {
                if (!simulate) {
                    this.inv.getInventory().set(offsetSlot, (Object)stack.func_77979_a(accepted));
                    this.inv.doGraphicalUpdates(offsetSlot);
                    return stack;
                }
                stack.func_190918_g(accepted);
                return stack;
            }
            if (!simulate) {
                this.inv.getInventory().set(offsetSlot, (Object)stack);
                this.inv.doGraphicalUpdates(offsetSlot);
            }
            return ItemStack.field_190927_a;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentStack)) {
            return stack;
        }
        int accepted = Math.min(stack.func_77976_d(), this.inv.getSlotLimit(offsetSlot)) - currentStack.func_190916_E();
        if (accepted < stack.func_190916_E()) {
            if (!simulate) {
                ItemStack newStack = stack.func_77979_a(accepted);
                newStack.func_190917_f(currentStack.func_190916_E());
                this.inv.getInventory().set(offsetSlot, (Object)newStack);
                this.inv.doGraphicalUpdates(offsetSlot);
                return stack;
            }
            stack.func_190918_g(accepted);
            return stack;
        }
        if (!simulate) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190917_f(currentStack.func_190916_E());
            this.inv.getInventory().set(offsetSlot, (Object)newStack);
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtract[slot] || amount == 0) {
            return ItemStack.field_190927_a;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = (ItemStack)this.inv.getInventory().get(offsetSlot);
        if (currentStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(currentStack.func_190916_E(), amount);
        ItemStack copy = currentStack.func_77946_l();
        copy.func_190920_e(extracted);
        if (!simulate) {
            if (extracted < currentStack.func_190916_E()) {
                currentStack.func_190918_g(extracted);
            } else {
                currentStack = ItemStack.field_190927_a;
            }
            this.inv.getInventory().set(offsetSlot, (Object)currentStack);
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.canInsert[slot] && this.inv.isStackValid(slot, stack);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inv.getInventory().set(this.slotOffset + slot, (Object)stack);
        this.inv.doGraphicalUpdates(this.slotOffset + slot);
    }
}

