/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.refinery;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeCategory
extends IERecipeCategory<RefineryRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "refinery");
    private final IDrawableStatic tankOverlay;

    public RefineryRecipeCategory(IGuiHelper helper) {
        super(RefineryRecipe.class, helper, UID, "block.immersiveengineering.refinery");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/refinery.png");
        this.setBackground(helper.createDrawable(background, 6, 10, 164, 62));
        this.setIcon(new ItemStack((IItemProvider)IEBlocks.Multiblocks.refinery));
        this.tankOverlay = helper.createDrawable(background, 179, 33, 16, 47);
    }

    public void setIngredients(RefineryRecipe recipe, IIngredients ingredients) {
        ArrayList<FluidStack> l = new ArrayList<FluidStack>();
        if (recipe.input0 != null) {
            l.add(recipe.input0);
        }
        if (recipe.input1 != null) {
            l.add(recipe.input1);
        }
        ingredients.setInputs(VanillaTypes.FLUID, l);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RefineryRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (recipe.input0 != null) {
            guiFluidStacks.init(0, true, 7, 10, 16, 47, 50, false, (IDrawable)this.tankOverlay);
            guiFluidStacks.set(0, recipe.input0);
        }
        if (recipe.input1 != null) {
            guiFluidStacks.init(1, true, 55, 10, 16, 47, 50, false, (IDrawable)this.tankOverlay);
            guiFluidStacks.set(1, recipe.input1);
        }
        guiFluidStacks.init(2, false, 103, 10, 16, 47, 50, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(2, recipe.output);
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }
}

