/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.crusher;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class CrusherRecipeCategory
extends IERecipeCategory<CrusherRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "crusher");

    public CrusherRecipeCategory(IGuiHelper helper) {
        super(CrusherRecipe.class, helper, UID, "block.immersiveengineering.crusher");
        this.setBackground(helper.createBlankDrawable(140, 54));
        this.setIcon(new ItemStack((IItemProvider)IEBlocks.Multiblocks.crusher));
    }

    public void setIngredients(CrusherRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).build());
        NonNullList<ItemStack> l = ListUtils.fromItems(recipe.output);
        for (StackWithChance output : recipe.secondaryOutputs) {
            if (output.getStack().func_190926_b()) continue;
            l.add((Object)output.getStack());
        }
        ingredients.setOutputs(VanillaTypes.ITEM, l);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrusherRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 18);
        guiItemStacks.set(0, Arrays.asList(recipe.input.func_193365_a()));
        guiItemStacks.setBackground(0, (IDrawable)JEIHelper.slotDrawable);
        List<StackWithChance> validSecondaries = this.getValidSecondaryOutputs(recipe);
        int y = validSecondaries.isEmpty() ? 18 : (validSecondaries.size() < 2 ? 9 : 0);
        guiItemStacks.init(1, false, 77, y);
        guiItemStacks.set(1, recipe.output);
        guiItemStacks.setBackground(1, (IDrawable)JEIHelper.slotDrawable);
        for (int i = 0; i < validSecondaries.size(); ++i) {
            guiItemStacks.init(2 + i, false, 77 + i / 2 * 44, y + 18 + i % 2 * 18);
            guiItemStacks.set(2 + i, validSecondaries.get(i).getStack());
            guiItemStacks.setBackground(2 + i, (IDrawable)JEIHelper.slotDrawable);
        }
    }

    public void draw(CrusherRecipe recipe, double mouseX, double mouseY) {
        List<StackWithChance> validSecondaries = this.getValidSecondaryOutputs(recipe);
        int yBase = validSecondaries.isEmpty() ? 36 : (validSecondaries.size() < 2 ? 27 : 18);
        for (int i = 0; i < validSecondaries.size(); ++i) {
            int x = 77 + i / 2 * 44;
            int y = yBase + i % 2 * 18;
            ClientUtils.font().func_211126_b(Utils.formatDouble(validSecondaries.get(i).getChance() * 100.0f, "0.##") + "%", (float)(x + 21), (float)(y + 6), 0x777777);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)3.0f, (float)3.0f, (float)1.0f);
        this.getIcon().draw(8, 0);
        RenderSystem.popMatrix();
    }

    private List<StackWithChance> getValidSecondaryOutputs(CrusherRecipe recipe) {
        ArrayList<StackWithChance> validSecondaries = new ArrayList<StackWithChance>();
        for (StackWithChance out : recipe.secondaryOutputs) {
            if (out.getStack().func_190926_b() || !(out.getChance() > 0.0f)) continue;
            validSecondaries.add(out);
        }
        return validSecondaries;
    }
}

