/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ArcFurnaceRecipeCategory
extends IERecipeCategory<ArcFurnaceRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "arcfurnace");
    public static final ResourceLocation UID_RECYCLING = new ResourceLocation("immersiveengineering", "arcfurnace_recycling");

    public ArcFurnaceRecipeCategory(IGuiHelper helper, Class<? extends ArcFurnaceRecipe> recipeClass, ResourceLocation uid) {
        super(recipeClass, helper, uid, "block.immersiveengineering.arc_furnace");
        this.setBackground(helper.createBlankDrawable(140, 54));
        this.setIcon(helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)IEBlocks.Multiblocks.arcFurnace)));
    }

    public static ArcFurnaceRecipeCategory getDefault(IGuiHelper helper) {
        return new ArcFurnaceRecipeCategory(helper, ArcFurnaceRecipe.class, UID);
    }

    public static ArcFurnaceRecipeCategory getRecycling(IGuiHelper helper) {
        ArcFurnaceRecipeCategory cat = new ArcFurnaceRecipeCategory(helper, ArcRecyclingRecipe.class, UID_RECYCLING);
        cat.localizedName = cat.localizedName + " - Recycling";
        cat.setIcon((IDrawable)helper.drawableBuilder(new ResourceLocation("immersiveengineering", "textures/gui/recycle.png"), 0, 0, 16, 16).setTextureSize(16, 16).build());
        return cat;
    }

    public void setIngredients(ArcFurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).add(recipe.additives).build());
        NonNullList<ItemStack> l = ListUtils.fromItems(recipe.output);
        if (recipe.slag == null) {
            System.out.println("ERROR ON RECIPE");
        } else if (!recipe.slag.func_190926_b()) {
            l.add((Object)recipe.slag);
        }
        ingredients.setOutputs(VanillaTypes.ITEM, l);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcFurnaceRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int i = 0;
        guiItemStacks.init(i, true, 20, 0);
        guiItemStacks.set(i++, Arrays.asList(recipe.input.getMatchingStacks()));
        ItemStack simulatedInput = recipe.input.getRandomizedExampleStack(0);
        NonNullList simulatedAdditives = NonNullList.func_191197_a((int)recipe.additives.length, (Object)ItemStack.field_190927_a);
        for (int j = 0; j < recipe.additives.length; ++j) {
            guiItemStacks.init(i, true, 12 + j % 2 * 18, 18 + j / 2 * 18);
            guiItemStacks.set(i++, Arrays.asList(recipe.additives[j].getMatchingStacks()));
            simulatedAdditives.set(j, (Object)recipe.additives[j].getRandomizedExampleStack(0));
        }
        NonNullList<ItemStack> simulatedOutput = recipe.getOutputs(simulatedInput, (NonNullList<ItemStack>)simulatedAdditives);
        int outputSize = simulatedOutput.size();
        for (int j = 0; j < outputSize; ++j) {
            ItemStack out = (ItemStack)simulatedOutput.get(j);
            if (out.func_190926_b()) {
                System.out.println("BLU, YOU FUCKED UP");
                continue;
            }
            int x = 122 - Math.min(outputSize - 1, 2) * 18 + j % 3 * 18;
            int y = (outputSize > 3 ? 0 : 18) + j / 3 * 18;
            guiItemStacks.init(i, false, x, y);
            guiItemStacks.set(i++, out);
        }
        if (!recipe.slag.func_190926_b()) {
            guiItemStacks.init(i, false, 122, 36);
            guiItemStacks.set(i++, recipe.slag);
        }
    }

    public void draw(ArcFurnaceRecipe recipe, double mouseX, double mouseY) {
        int j;
        JEIHelper.slotDrawable.draw(20, 0);
        for (j = 0; j < 4; ++j) {
            JEIHelper.slotDrawable.draw(12 + j % 2 * 18, 18 + j / 2 * 18);
        }
        for (j = 0; j < 6; ++j) {
            JEIHelper.slotDrawable.draw(86 + j % 3 * 18, 0 + j / 3 * 18);
        }
        JEIHelper.slotDrawable.draw(122, 36);
        float time = recipe.getTotalProcessTime();
        float energy = (float)recipe.getTotalProcessEnergy() / time;
        Utils.formatDouble(energy, "#.##");
        String s = I18n.func_135052_a((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.formatDouble(energy, "#.##")});
        ClientUtils.font().func_211126_b(s, 54.0f, 38.0f, 0x777777);
        s = I18n.func_135052_a((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble(time / 20.0f, "#.##")});
        ClientUtils.font().func_211126_b(s, 54.0f, 48.0f, 0x777777);
    }
}

