/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CommandMineral {
    public static LiteralArgumentBuilder<CommandSource> create() {
        LiteralArgumentBuilder main = Commands.func_197057_a((String)"mineral");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)main.then(CommandMineral.listMineral())).then(CommandMineral.getMineral())).then(CommandMineral.setMineral())).then(CommandMineral.setMineralDepletion());
        return main;
    }

    private static LiteralArgumentBuilder<CommandSource> listMineral() {
        LiteralArgumentBuilder list = Commands.func_197057_a((String)"list");
        list.executes(command -> {
            StringBuilder s = new StringBuilder();
            int i = 0;
            for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.values()) {
                s.append(i++ > 0 ? ", " : "").append(mm.func_199560_c());
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(s.toString()), true);
            return 1;
        });
        return list;
    }

    private static LiteralArgumentBuilder<CommandSource> getMineral() {
        LiteralArgumentBuilder get = Commands.func_197057_a((String)"get");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)get.requires(source -> source.func_197034_c(2))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CommandMineral.getMineral((CommandContext<CommandSource>)command, player.func_180425_c().func_177958_n() >> 4, player.func_180425_c().func_177952_p() >> 4);
            return 1;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = (ColumnPos)command.getArgument("location", ColumnPos.class);
            CommandMineral.getMineral((CommandContext<CommandSource>)command, pos.field_219439_a, pos.field_219440_b);
            return 1;
        }));
        return get;
    }

    private static void getMineral(CommandContext<CommandSource> context, int xChunk, int zChunk) {
        CommandSource sender = (CommandSource)context.getSource();
        ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((World)sender.func_197023_e(), xChunk, zChunk);
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.get", new Object[]{TextFormatting.GOLD + (info.mineral != null ? info.mineral.func_199560_c().toString() : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.mineralOverride != null ? info.mineralOverride.func_199560_c().toString() : "null") + TextFormatting.RESET, TextFormatting.GOLD + "" + info.depletion + TextFormatting.RESET}), true);
    }

    private static LiteralArgumentBuilder<CommandSource> setMineral() {
        LiteralArgumentBuilder set = Commands.func_197057_a((String)"set");
        RequiredArgumentBuilder mineralArg = Commands.func_197056_a((String)"mineral", (ArgumentType)new MineralArgument());
        ((RequiredArgumentBuilder)((RequiredArgumentBuilder)mineralArg.requires(source -> source.func_197034_c(2))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CommandMineral.setMineral((CommandContext<CommandSource>)command, player.func_180425_c().func_177958_n() >> 4, player.func_180425_c().func_177952_p() >> 4);
            return 1;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = (ColumnPos)command.getArgument("location", ColumnPos.class);
            CommandMineral.setMineral((CommandContext<CommandSource>)command, pos.field_219439_a, pos.field_219440_b);
            return 1;
        }));
        set.then((ArgumentBuilder)mineralArg);
        return set;
    }

    private static void setMineral(CommandContext<CommandSource> context, int xChunk, int zChunk) {
        ExcavatorHandler.MineralMix mineral;
        CommandSource sender = (CommandSource)context.getSource();
        ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((World)sender.func_197023_e(), xChunk, zChunk);
        info.mineralOverride = mineral = (ExcavatorHandler.MineralMix)context.getArgument("mineral", ExcavatorHandler.MineralMix.class);
        IESaveData.setDirty();
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.set.sucess", new Object[]{mineral.func_199560_c()}), true);
    }

    private static LiteralArgumentBuilder<CommandSource> setMineralDepletion() {
        LiteralArgumentBuilder setDepletion = Commands.func_197057_a((String)"setDepletion");
        RequiredArgumentBuilder mineralArg = Commands.func_197056_a((String)"depletion", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)100));
        ((RequiredArgumentBuilder)((RequiredArgumentBuilder)mineralArg.requires(source -> source.func_197034_c(2))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CommandMineral.setMineralDepletion((CommandContext<CommandSource>)command, player.func_180425_c().func_177958_n() >> 4, player.func_180425_c().func_177952_p() >> 4);
            return 1;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = (ColumnPos)command.getArgument("location", ColumnPos.class);
            CommandMineral.setMineralDepletion((CommandContext<CommandSource>)command, pos.field_219439_a, pos.field_219440_b);
            return 1;
        }));
        setDepletion.then((ArgumentBuilder)mineralArg);
        return setDepletion;
    }

    private static void setMineralDepletion(CommandContext<CommandSource> context, int xChunk, int zChunk) {
        int depl;
        CommandSource sender = (CommandSource)context.getSource();
        ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((World)sender.func_197023_e(), xChunk, zChunk);
        info.depletion = depl = ((Integer)context.getArgument("depletion", Integer.class)).intValue();
    }

    private static class MineralArgument
    implements ArgumentType<ExcavatorHandler.MineralMix> {
        public static final DynamicCommandExceptionType invalidVein = new DynamicCommandExceptionType(input -> new TranslationTextComponent("chat.immersiveengineering.command.mineral.invalid", new Object[]{input}));

        private MineralArgument() {
        }

        public ExcavatorHandler.MineralMix parse(StringReader reader) throws CommandSyntaxException {
            String name = reader.readQuotedString();
            for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.values()) {
                if (!mm.func_199560_c().toString().equalsIgnoreCase(name)) continue;
                return mm;
            }
            throw invalidVein.create((Object)name);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(ExcavatorHandler.mineralList.values().stream().map(mix -> "\"" + mix.func_199560_c() + "\""), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            ArrayList<String> ret = new ArrayList<String>();
            for (ExcavatorHandler.MineralMix mix : ExcavatorHandler.mineralList.values()) {
                ret.add("\"" + mix.func_199560_c() + "\"");
                if (ret.size() <= 5) continue;
                break;
            }
            return ret;
        }
    }
}

