/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageWireSync
implements IMessage {
    private ConnectionPoint start;
    private ConnectionPoint end;
    private WireType type;
    private boolean added;

    public MessageWireSync(Connection conn, boolean added) {
        this.start = conn.getEndA();
        this.end = conn.getEndB();
        this.type = conn.type;
        this.added = added;
    }

    public MessageWireSync(PacketBuffer buf) {
        this.added = buf.readBoolean();
        this.start = this.readConnPoint(buf);
        this.end = this.readConnPoint(buf);
        this.type = WireType.getValue(buf.func_150789_c(128));
    }

    private ConnectionPoint readConnPoint(PacketBuffer buf) {
        return new ConnectionPoint(buf.func_179259_c(), buf.readInt());
    }

    private void writeConnPoint(ConnectionPoint cp, PacketBuffer buf) {
        buf.func_179255_a(cp.getPosition());
        buf.writeInt(cp.getIndex());
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        PacketBuffer pb = new PacketBuffer((ByteBuf)buf);
        pb.writeBoolean(this.added);
        this.writeConnPoint(this.start, pb);
        this.writeConnPoint(this.end, pb);
        pb.func_180714_a(this.type.getUniqueName());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity endTE;
            WireLogger.logger.debug("Processing sync for connection from {} to {}, type {}, adding {}", (Object)this.start, (Object)this.end, (Object)this.type, (Object)this.added);
            PlayerEntity player = ImmersiveEngineering.proxy.getClientPlayer();
            World w = player.field_70170_p;
            IChunk startChunk = w.func_217353_a(this.start.getPosition().func_177958_n() >> 4, this.start.getPosition().func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
            if (startChunk == null) {
                WireLogger.logger.debug("Start chunk is null");
            }
            GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(w);
            if (this.added) {
                globalNet.addConnection(new Connection(this.type, this.start, this.end));
            } else {
                globalNet.removeConnection(new Connection(this.type, this.start, this.end));
            }
            TileEntity startTE = w.func_175625_s(this.start.getPosition());
            if (startTE != null) {
                startTE.requestModelDataUpdate();
            }
            if ((endTE = w.func_175625_s(this.end.getPosition())) != null) {
                endTE.requestModelDataUpdate();
            }
            BlockState state = w.func_180495_p(this.start.getPosition());
            w.func_184138_a(this.start.getPosition(), state, state, 3);
            state = w.func_180495_p(this.end.getPosition());
            w.func_184138_a(this.end.getPosition(), state, state, 3);
        });
    }
}

