/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.loot;

import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationTracker;

public abstract class LootGenerator
implements IDataProvider {
    private final DataGenerator dataGenerator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<ResourceLocation, LootTable> tables = Maps.newHashMap();

    public LootGenerator(DataGenerator gen) {
        this.dataGenerator = gen;
    }

    public void func_200398_a(@Nonnull DirectoryCache outCache) {
        this.tables.clear();
        Path outFolder = this.dataGenerator.func_200391_b();
        this.registerTables();
        ValidationTracker validator = new ValidationTracker(LootParameterSets.field_216266_g, p_229442_0_ -> null, this.tables::get);
        this.tables.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.func_227527_a_();
        if (!problems.isEmpty()) {
            problems.forEach((name, table) -> IELogger.logger.warn("Found validation problem in " + name + ": " + table));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        this.tables.forEach((name, table) -> {
            Path out = LootGenerator.getPath(outFolder, name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)outCache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)out);
            }
            catch (IOException x) {
                IELogger.logger.error("Couldn't save loot table {}", (Object)out, (Object)x);
            }
        });
    }

    private static Path getPath(Path p_218439_0_, ResourceLocation p_218439_1_) {
        return p_218439_0_.resolve("data/" + p_218439_1_.func_110624_b() + "/loot_tables/" + p_218439_1_.func_110623_a() + ".json");
    }

    protected abstract void registerTables();
}

