/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class MetalPressRecipeSerializer
extends IERecipeSerializer<MetalPressRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.metalPress);
    }

    @Override
    public MetalPressRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        ItemStack mold = this.readOutput(json.get("mold"));
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        return new MetalPressRecipe(recipeId, output, input, new ComparableItemStack(mold), energy);
    }

    @Nullable
    public MetalPressRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack output = buffer.func_150791_c();
        IngredientWithSize input = IngredientWithSize.read(buffer);
        ItemStack mold = buffer.func_150791_c();
        int energy = buffer.readInt();
        return new MetalPressRecipe(recipeId, output, input, new ComparableItemStack(mold), energy);
    }

    public void write(PacketBuffer buffer, MetalPressRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        recipe.input.write(buffer);
        buffer.func_150788_a(recipe.mold.stack);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

