/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.DamageToolRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DamageToolRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<DamageToolRecipe> {
    public static final IRecipeSerializer<DamageToolRecipe> INSTANCE = IRecipeSerializer.func_222156_a((String)"immersiveengineering:damage_tool", (IRecipeSerializer)new DamageToolRecipeSerializer());

    @Nonnull
    public DamageToolRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        NonNullList<Ingredient> defIngredients = DamageToolRecipeSerializer.readIngredients(json.getAsJsonArray("ingredients"));
        Ingredient tool = Ingredient.func_199802_a((JsonElement)json.get("tool"));
        String group = json.get("group").getAsString();
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("result"));
        return new DamageToolRecipe(recipeId, group, result, tool, defIngredients);
    }

    @Nonnull
    public DamageToolRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int stdCount = buffer.readInt();
        NonNullList stdIngr = NonNullList.func_191196_a();
        for (int i = 0; i < stdCount; ++i) {
            stdIngr.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        Ingredient tool = Ingredient.func_199566_b((PacketBuffer)buffer);
        String group = buffer.func_150789_c(512);
        ItemStack output = buffer.func_150791_c();
        return new DamageToolRecipe(recipeId, group, output, tool, (NonNullList<Ingredient>)stdIngr);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull DamageToolRecipe recipe) {
        int standardCount = recipe.func_192400_c().size() - 1;
        buffer.writeInt(standardCount);
        for (int i = 0; i < standardCount; ++i) {
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)((Ingredient)recipe.func_192400_c().get(i)));
        }
        CraftingHelper.write((PacketBuffer)buffer, (Ingredient)recipe.getTool());
        buffer.func_180714_a(recipe.func_193358_e());
        buffer.func_150788_a(recipe.func_77571_b());
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray all) {
        NonNullList ret = NonNullList.func_191196_a();
        for (int i = 0; i < all.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)all.get(i));
            if (ingredient.func_203189_d()) continue;
            ret.add((Object)ingredient);
        }
        return ret;
    }
}

