/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class BlastFurnaceRecipeSerializer
extends IERecipeSerializer<BlastFurnaceRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.blastFurnace);
    }

    @Override
    public BlastFurnaceRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        int time = JSONUtils.func_151208_a((JsonObject)json, (String)"time", (int)200);
        ItemStack slag = ItemStack.field_190927_a;
        if (json.has("slag")) {
            slag = this.readOutput((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"slag"));
        }
        return new BlastFurnaceRecipe(recipeId, output, input, time, slag);
    }

    @Nullable
    public BlastFurnaceRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack output = buffer.func_150791_c();
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        ItemStack slag = ItemStack.field_190927_a;
        if (buffer.readBoolean()) {
            slag = buffer.func_150791_c();
        }
        return new BlastFurnaceRecipe(recipeId, output, input, time, slag);
    }

    public void write(PacketBuffer buffer, BlastFurnaceRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.time);
        buffer.writeBoolean(!recipe.slag.func_190926_b());
        if (!recipe.slag.func_190926_b()) {
            buffer.func_150788_a(recipe.slag);
        }
    }
}

