/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingThreadHandler;
import blusunrize.immersiveengineering.common.crafting.MixerRecipePotion;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    public void func_195410_a(IResourceManager resourceManager) {
        if (EffectiveSide.get().isServer()) {
            RecipeReloadListener.buildRecipeLists(ServerLifecycleHooks.getCurrentServer().func_199529_aN());
        }
    }

    @SubscribeEvent
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeReloadListener.buildRecipeLists(event.getRecipeManager());
    }

    static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        ArcRecyclingThreadHandler recyclingHandler = new ArcRecyclingThreadHandler(recipes);
        recyclingHandler.start();
        AlloyRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, AlloyRecipe.class, AlloyRecipe.TYPE);
        BlastFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceRecipe.class, BlastFurnaceRecipe.TYPE);
        BlastFurnaceFuel.blastFuels = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceFuel.class, BlastFurnaceFuel.TYPE);
        CokeOvenRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CokeOvenRecipe.class, CokeOvenRecipe.TYPE);
        ClocheRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ClocheRecipe.class, ClocheRecipe.TYPE);
        BlueprintCraftingRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlueprintCraftingRecipe.class, BlueprintCraftingRecipe.TYPE);
        BlueprintCraftingRecipe.updateRecipeCategories();
        MetalPressRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MetalPressRecipe.class, MetalPressRecipe.TYPE);
        MetalPressRecipe.updateRecipesByMold();
        ArcFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ArcFurnaceRecipe.class, ArcFurnaceRecipe.TYPE);
        BottlingMachineRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BottlingMachineRecipe.class, BottlingMachineRecipe.TYPE);
        CrusherRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CrusherRecipe.class, CrusherRecipe.TYPE);
        FermenterRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, FermenterRecipe.class, FermenterRecipe.TYPE);
        SqueezerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SqueezerRecipe.class, SqueezerRecipe.TYPE);
        RefineryRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, RefineryRecipe.class, RefineryRecipe.TYPE);
        MixerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MixerRecipe.class, MixerRecipe.TYPE);
        ExcavatorHandler.mineralList = RecipeReloadListener.filterRecipes(recipes, ExcavatorHandler.MineralMix.class, ExcavatorHandler.MineralMix.TYPE);
        MixerRecipePotion.initPotionRecipes();
        try {
            recyclingHandler.join();
            recyclingHandler.finishUp();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

