/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;

public class MixerRecipePotion
extends MixerRecipe {
    public static final HashMap<Potion, MixerRecipePotion> REGISTERED = new HashMap();
    public static final Set<String> BLACKLIST = new HashSet<String>();
    private final Set<Pair<FluidStack, IngredientWithSize[]>> alternateInputs = new HashSet<Pair<FluidStack, IngredientWithSize[]>>();

    public MixerRecipePotion(ResourceLocation id, Potion outputType, Potion inputType, IngredientWithSize reagent) {
        super(id, MixerRecipePotion.getFluidStackForType(outputType, 1000), MixerRecipePotion.getFluidStackForType(inputType, 1000), new IngredientWithSize[]{reagent}, 6400);
    }

    public void addAlternateInput(Potion inputType, IngredientWithSize reagent) {
        this.alternateInputs.add((Pair<FluidStack, IngredientWithSize[]>)Pair.of((Object)MixerRecipePotion.getFluidStackForType(inputType, 1000), (Object)new IngredientWithSize[]{reagent}));
    }

    public Set<Pair<FluidStack, IngredientWithSize[]>> getAlternateInputs() {
        return this.alternateInputs;
    }

    public static void initPotionRecipes() {
        REGISTERED.clear();
        try {
            String mixPredicateName = "net.minecraft.potion.PotionBrewing$MixPredicate";
            Class<?> mixPredicateClass = Class.forName(mixPredicateName);
            Field f_input = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185198_a");
            Field f_reagent = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185199_b");
            Field f_output = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185200_c");
            f_input.setAccessible(true);
            f_reagent.setAccessible(true);
            f_output.setAccessible(true);
            List l = PotionBrewing.field_185213_a;
            for (Object mixPredicate : PotionBrewing.field_185213_a) {
                Ingredient reagent = (Ingredient)f_reagent.get(mixPredicate);
                IRegistryDelegate input = (IRegistryDelegate)f_input.get(mixPredicate);
                IRegistryDelegate output = (IRegistryDelegate)f_output.get(mixPredicate);
                MixerRecipePotion.registerPotionRecipe((Potion)output.get(), (Potion)input.get(), new IngredientWithSize(reagent));
            }
        }
        catch (Exception e) {
            IELogger.error("Error when trying to figure out vanilla potion recipes", e);
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            IngredientWithSize ingredient = new IngredientWithSize(((BrewingRecipe)recipe).getIngredient());
            Ingredient input = ((BrewingRecipe)recipe).getInput();
            ItemStack output = ((BrewingRecipe)recipe).getOutput();
            if (output.func_77973_b() != Items.field_151068_bn) continue;
            MixerRecipePotion.registerPotionRecipe(PotionUtils.func_185191_c((ItemStack)output), PotionUtils.func_185191_c((ItemStack)input.func_193365_a()[0]), ingredient);
        }
    }

    public static void registerPotionRecipe(Potion output, Potion input, IngredientWithSize reagent) {
        if (REGISTERED.containsKey(output)) {
            MixerRecipePotion recipe = REGISTERED.get(output);
            recipe.addAlternateInput(input, reagent);
        } else if (!BLACKLIST.contains(output.getRegistryName().toString())) {
            MixerRecipePotion recipe = new MixerRecipePotion(output.getRegistryName(), output, input, reagent);
            MixerRecipe.recipeList.put(recipe.func_199560_c(), recipe);
            REGISTERED.put(output, recipe);
            BottlingMachineRecipe bottling = new BottlingMachineRecipe(output.getRegistryName(), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)output), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), MixerRecipePotion.getFluidStackForType(output, 250));
            BottlingMachineRecipe.recipeList.put(bottling.func_199560_c(), bottling);
        }
    }

    public static FluidStack getFluidStackForType(Potion type, int amount) {
        if (type == Potions.field_185230_b || type == null) {
            return new FluidStack((Fluid)Fluids.field_204546_a, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.getOrCreateTag().func_74778_a("Potion", type.getRegistryName().toString());
        return stack;
    }

    @Override
    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        if (super.matches(fluid, components)) {
            return true;
        }
        return this.alternateInputs.stream().anyMatch(alternate -> this.compareToInputs(fluid, components, (FluidStack)alternate.getLeft(), (IngredientWithSize[])alternate.getRight()));
    }

    @Override
    public int[] getUsedSlots(FluidStack fluid, NonNullList<ItemStack> components) {
        for (int i = 0; i < components.size(); ++i) {
            if (((ItemStack)components.get(i)).func_190926_b() || !BrewingRecipeRegistry.isValidIngredient((ItemStack)((ItemStack)components.get(i)))) continue;
            return new int[]{i};
        }
        return new int[0];
    }
}

