/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientSerializerFluidStack
implements IIngredientSerializer<IngredientFluidStack> {
    public static ResourceLocation NAME = new ResourceLocation("immersiveengineering", "fluid");
    public static IIngredientSerializer<IngredientFluidStack> INSTANCE = new IngredientSerializerFluidStack();

    @Nonnull
    public IngredientFluidStack parse(@Nonnull PacketBuffer buffer) {
        ResourceLocation name = new ResourceLocation(buffer.func_150789_c(512));
        int amount = buffer.readInt();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(name);
        if (fluid == null) {
            throw new JsonSyntaxException("Fluid with name " + name + " could not be found");
        }
        return new IngredientFluidStack(fluid, amount);
    }

    @Nonnull
    public IngredientFluidStack parse(@Nonnull JsonObject json) {
        ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(name);
        if (fluid == null) {
            throw new JsonSyntaxException("Fluid with name " + name + " could not be found");
        }
        return new IngredientFluidStack(fluid, amount);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull IngredientFluidStack ingredient) {
        buffer.func_180714_a(ingredient.getFluid().getFluid().getRegistryName().toString());
        buffer.writeInt(ingredient.getFluid().getAmount());
    }
}

