/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class IEConfigConditionSerializer
implements IConditionSerializer<ConditionIEConfig> {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "config");

    public void write(JsonObject json, ConditionIEConfig value) {
        json.addProperty("key", value.key);
        json.addProperty("value", Boolean.valueOf(value.value));
    }

    public ConditionIEConfig read(JsonObject json) {
        String key = JSONUtils.func_151200_h((JsonObject)json, (String)"key");
        boolean value = JSONUtils.func_151209_a((JsonObject)json, (String)"value", (boolean)true);
        return new ConditionIEConfig(value, key);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static class ConditionIEConfig
    implements ICondition {
        private final boolean value;
        private final String key;

        public ConditionIEConfig(boolean value, String key) {
            this.value = value;
            this.key = key;
        }

        public ResourceLocation getID() {
            return ID;
        }

        public boolean test() {
            UnmodifiableConfig config = IEConfig.ALL.getValues();
            Object configEntry = config.get(this.key);
            if (configEntry instanceof ForgeConfigSpec.BooleanValue) {
                Boolean configValue = (Boolean)((ForgeConfigSpec.BooleanValue)configEntry).get();
                return configValue != null && configValue == this.value;
            }
            IELogger.error("Unknown config value {}", this.key);
            return false;
        }
    }
}

