/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootContext;

public class CoresampleTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<CoresampleTileEntity> TYPE;
    public ItemStack coresample = ItemStack.field_190927_a;
    private String[] overlay = null;
    private static final VoxelShape AABB_CORESAMPLE_X;
    private static final VoxelShape AABB_CORESAMPLE_Z;

    public CoresampleTileEntity() {
        super(TYPE);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.coresample = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("coresample"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_218657_a("coresample", (INBT)this.coresample.func_77955_b(new CompoundNBT()));
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_225608_bj_()) {
            if (!this.field_145850_b.field_72995_K) {
                ItemEntity entityitem = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.coresample);
                entityitem.func_174869_p();
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
                this.field_145850_b.func_217376_c((Entity)entityitem);
            }
            return true;
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151098_aY && ItemNBTHelper.hasKey(this.coresample, "coords")) {
            MapData mapData;
            if (!this.field_145850_b.field_72995_K && (mapData = FilledMapItem.func_195950_a((ItemStack)heldItem, (World)player.func_130014_f_())) != null) {
                int[] coords = ItemNBTHelper.getIntArray(this.coresample, "coords");
                String ident = "ie:coresample_" + coords[0] + ";" + coords[1] + ";" + coords[2];
                CompoundNBT mapTagCompound = heldItem.func_196082_o();
                ListNBT nbttaglist = mapTagCompound.func_150295_c("Decorations", 10);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundNBT tagCompound = (CompoundNBT)nbttaglist.get(i);
                    if (!ident.equalsIgnoreCase(tagCompound.func_74779_i("id"))) continue;
                    nbttaglist.remove(i);
                    mapTagCompound.func_218657_a("Decorations", (INBT)nbttaglist);
                    mapData.field_76203_h.remove(ident);
                    return true;
                }
                double sampleX = (double)(coords[1] * 16) + 8.5;
                double sampleZ = (double)(coords[2] * 16) + 8.5;
                int mapScale = 1 << mapData.field_76197_d;
                float distX = (float)(sampleX - (double)mapData.field_76201_a) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.field_76199_b) / (float)mapScale;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    CompoundNBT tagCompound = new CompoundNBT();
                    tagCompound.func_74778_a("id", ident);
                    tagCompound.func_74774_a("type", MapDecoration.Type.TARGET_POINT.func_191163_a());
                    tagCompound.func_74780_a("x", sampleX);
                    tagCompound.func_74780_a("z", sampleZ);
                    tagCompound.func_74780_a("rot", 180.0);
                    nbttaglist.add((Object)tagCompound);
                    mapTagCompound.func_218657_a("Decorations", (INBT)nbttaglist);
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.mapFail", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        if (this.coresample.func_82837_s()) {
            return this.coresample.func_200301_q();
        }
        return new TranslationTextComponent("item.immersiveengineering.coresample.name", new Object[0]);
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        return ImmutableList.of((Object)this.coresample);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        this.coresample = stack.func_77946_l();
    }

    @Override
    public String[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (this.coresample != null && ItemNBTHelper.hasKey(this.coresample, "coords", 10)) {
            if (this.overlay == null) {
                this.overlay = new String[3];
                CompoundNBT coordNBT = ItemNBTHelper.getTagCompound(this.coresample, "coords");
                DimensionChunkCoords dimPos = DimensionChunkCoords.readFromNBT(coordNBT);
                String dimName = ItemNBTHelper.getString(this.coresample, "dimension");
                this.overlay[0] = I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.noMineral", (Object[])new Object[0]);
                if (ItemNBTHelper.hasKey(this.coresample, "mineral")) {
                    String loc;
                    ResourceLocation rl = new ResourceLocation(ItemNBTHelper.getString(this.coresample, "mineral"));
                    ExcavatorHandler.MineralMix mineral = ExcavatorHandler.mineralList.get(rl);
                    String unloc = mineral.getTranslationKey();
                    if (unloc.equals(loc = I18n.func_135052_a((String)unloc, (Object[])new Object[0]))) {
                        loc = mineral.getPlainName();
                    }
                    this.overlay[0] = TextFormatting.GOLD + I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.mineral", (Object[])new Object[]{loc});
                }
                String s0 = dimPos.field_77276_a * 16 + ", " + dimPos.field_77275_b * 16;
                String s1 = dimPos.field_77276_a * 16 + 16 + ", " + (dimPos.field_77275_b * 16 + 16);
                String name = dimPos.dimension.getRegistryName().func_110623_a();
                if (name.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                    name = name.substring(4);
                }
                this.overlay[1] = Utils.toCamelCase(name);
                this.overlay[2] = I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.pos", (Object[])new Object[]{s0, s1});
            }
            return this.overlay;
        }
        return new String[0];
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds() {
        return this.getFacing().func_176740_k() == Direction.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
    }

    static {
        AABB_CORESAMPLE_X = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.28125, (double)1.0, (double)1.0, (double)0.71875);
        AABB_CORESAMPLE_Z = VoxelShapes.func_197873_a((double)0.28125, (double)0.0, (double)0.0, (double)0.71875, (double)1.0, (double)1.0);
    }
}

