/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.shapes.CachedVoxelShapes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class VerticalConveyor
extends BasicConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "vertical");
    private Map<TileEntity, CapabilityReference<IItemHandler>> inserters = new WeakHashMap<TileEntity, CapabilityReference<IItemHandler>>();
    static final AxisAlignedBB[] verticalBounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private static final CachedVoxelShapes<Pair<Direction, Boolean>> SHAPES = new CachedVoxelShapes<Pair>(VerticalConveyor::getShapes);
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/vertical");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/vertical_off");

    public VerticalConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public boolean renderWall(Direction facing, int wall) {
        return true;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public String getModelCacheKey() {
        String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
        key = key + "f" + this.getFacing().ordinal();
        key = key + "a" + (this.isActive() ? 1 : 0);
        key = key + "b" + (VerticalConveyor.renderBottomBelt(this.getTile(), this.getFacing()) ? "1" + (this.renderBottomWall(this.getTile(), this.getFacing(), 0) ? "1" : "0") + (this.renderBottomWall(this.getTile(), this.getFacing(), 1) ? "1" : "0") : "000");
        key = key + "c" + this.getDyeColour();
        if (this.allowCovers() && this.cover != Blocks.field_150350_a) {
            key = key + "s" + this.cover.getRegistryName();
        }
        return key;
    }

    static boolean renderBottomBelt(TileEntity tile, Direction facing) {
        TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0));
        if (te instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype() != null) {
            for (Direction f : ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype().sigTransportDirections()) {
                if (f != Direction.UP) continue;
                return false;
            }
        }
        for (Direction f : Direction.field_176754_o) {
            if (f == facing || !VerticalConveyor.isInwardConveyor(tile, f)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInwardConveyor(TileEntity tile, Direction f) {
        ConveyorHandler.IConveyorBelt sub;
        TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(f));
        if (te instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f != f2.func_176734_d()) continue;
                return true;
            }
        }
        if ((te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0).func_177972_a(f))) instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
            int b = 0;
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f == f2.func_176734_d()) {
                    ++b;
                } else if (Direction.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean renderBottomWall(TileEntity tile, Direction facing, int wall) {
        return super.renderWall(facing, wall);
    }

    @Override
    public Direction[] sigTransportDirections() {
        return new Direction[]{Direction.UP, this.getFacing()};
    }

    @Override
    public Vec3d getDirection(Entity entity) {
        BlockPos posWall = this.getTile().func_174877_v().func_177972_a(this.getFacing());
        double d = 0.625 + (double)entity.func_213311_cf();
        double distToWall = Math.abs((double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + 0.5 - (this.getFacing().func_176740_k() == Direction.Axis.Z ? entity.func_226281_cx_() : entity.func_226277_ct_()));
        if (distToWall > d) {
            return super.getDirection(entity);
        }
        double vBase = entity instanceof LivingEntity ? 1.5 : 1.15;
        double distY = Math.abs((double)this.getTile().func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + 0.5 - entity.func_226278_cu_());
        double treshold = 0.9;
        boolean contact = distY < treshold;
        double vX = entity.func_213322_ci().field_72450_a;
        double vY = 0.1 * vBase;
        double vZ = entity.func_213322_ci().field_72449_c;
        if (entity.func_213322_ci().field_72448_b < 0.0) {
            vY += entity.func_213322_ci().field_72448_b * 0.9;
        }
        if (!(entity instanceof PlayerEntity)) {
            vX = 0.05 * (double)this.getFacing().func_82601_c();
            vZ = 0.05 * (double)this.getFacing().func_82599_e();
            if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
                if (entity.func_226281_cx_() > (double)this.getTile().func_174877_v().func_177952_p() + 0.65) {
                    vZ = -0.1 * vBase;
                } else if (entity.func_226281_cx_() < (double)this.getTile().func_174877_v().func_177952_p() + 0.35) {
                    vZ = 0.1 * vBase;
                }
            } else if (this.getFacing() == Direction.NORTH || this.getFacing() == Direction.SOUTH) {
                if (entity.func_226277_ct_() > (double)this.getTile().func_174877_v().func_177958_n() + 0.65) {
                    vX = -0.1 * vBase;
                } else if (entity.func_226277_ct_() < (double)this.getTile().func_174877_v().func_177958_n() + 0.35) {
                    vX = 0.1 * vBase;
                }
            }
        }
        BlockPos upForward = this.getTile().func_174877_v().func_177982_a(0, 1, 0);
        if (contact && !(Utils.getExistingTileEntity(this.getTile().func_145831_w(), upForward) instanceof ConveyorHandler.IConveyorTile)) {
            vY *= 2.25;
        }
        return new Vec3d(vX, vY, vZ);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.isActive()) {
            return;
        }
        BlockPos posWall = this.getTile().func_174877_v().func_177972_a(this.getFacing());
        double d = 0.625 + (double)entity.func_213311_cf();
        double distToWall = Math.abs((double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + 0.5 - (this.getFacing().func_176740_k() == Direction.Axis.Z ? entity.func_226281_cx_() : entity.func_226277_ct_()));
        if (distToWall > d) {
            super.onEntityCollision(entity);
            return;
        }
        if (!(entity == null || !entity.func_70089_S() || entity instanceof PlayerEntity && entity.func_225608_bj_())) {
            double treshold;
            double distY = Math.abs((double)this.getTile().func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + 0.5 - entity.func_226278_cu_());
            boolean contact = distY < (treshold = 0.9);
            entity.field_70122_E = false;
            entity.field_70143_R = entity.field_70143_R < 3.0f ? 0.0f : (float)((double)entity.field_70143_R * 0.9);
            Vec3d vec = this.getDirection(entity);
            entity.func_213317_d(vec);
            if (!contact) {
                ConveyorHandler.applyMagnetSupression(entity, (ConveyorHandler.IConveyorTile)this.getTile());
            } else {
                BlockPos posTop = this.getTile().func_174877_v().func_177982_a(0, 1, 0);
                if (!(this.getTile().func_145831_w().func_175625_s(posTop) instanceof ConveyorHandler.IConveyorTile || this.getTile().func_145831_w().func_175623_d(posTop) && this.getTile().func_145831_w().func_175625_s(posTop.func_177972_a(this.getFacing())) instanceof ConveyorHandler.IConveyorTile)) {
                    ConveyorHandler.revertMagnetSupression(entity, (ConveyorHandler.IConveyorTile)this.getTile());
                }
            }
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (!contact) {
                    if (item.field_70292_b > item.lifespan - 1200) {
                        item.field_70292_b = item.lifespan - 1200;
                    }
                } else {
                    ItemStack stack;
                    TileEntity inventoryTile = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177982_a(0, 1, 0));
                    if (!(this.getTile().func_145831_w().field_72995_K || inventoryTile == null || inventoryTile instanceof ConveyorHandler.IConveyorTile || (stack = item.func_92059_d()).func_190926_b())) {
                        CapabilityReference insert = this.inserters.computeIfAbsent(this.getTile(), te -> CapabilityReference.forNeighbor(te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN));
                        ItemStack ret = Utils.insertStackIntoInventory(insert, stack, false);
                        if (ret.func_190926_b()) {
                            entity.func_70106_y();
                        } else if (ret.func_190916_E() < stack.func_190916_E()) {
                            item.func_92058_a(ret);
                        }
                    }
                }
            }
        }
        if (this.allowCovers() && entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_174867_a(10);
        }
    }

    @Override
    public VoxelShape getSelectionShape() {
        return SHAPES.get((Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)VerticalConveyor.renderBottomBelt(this.getTile(), this.getFacing())));
    }

    private static List<AxisAlignedBB> getShapes(Pair<Direction, Boolean> key) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (((Direction)key.getLeft()).ordinal() > 1) {
            list.add(verticalBounds[((Direction)key.getLeft()).ordinal() - 2]);
        }
        if (((Boolean)key.getRight()).booleanValue() || list.isEmpty()) {
            list.add(conveyorBounds.func_197752_a());
        }
        return list;
    }

    @Override
    public VoxelShape getCollisionShape() {
        return this.getSelectionShape();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix modifyBaseRotationMatrix(TransformationMatrix matrix) {
        return matrix.compose(new TransformationMatrix(new Vector3f(0.0f, 1.0f, 0.0f), new Quaternion(1.5707964f, 0.0f, 0.0f, false), null, null));
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        if (this.getTile() != null && VerticalConveyor.renderBottomBelt(this.getTile(), this.getFacing())) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(this.isActive() ? BasicConveyor.texture_on : BasicConveyor.texture_off);
            TextureAtlasSprite spriteColour = ClientUtils.getSprite(this.getColouredStripesTexture());
            boolean[] walls = new boolean[]{this.renderBottomWall(this.getTile(), this.getFacing(), 0), this.renderBottomWall(this.getTile(), this.getFacing(), 1)};
            baseModel.addAll(ModelConveyor.getBaseConveyor(this.getFacing(), 0.875f, ClientUtils.rotateTo(this.getFacing()), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, this.getDyeColour()));
        }
        return baseModel;
    }
}

