/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ExtractConveyor
extends BasicConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "extract");
    private int transferCooldown = -1;
    private int transferTickrate = 8;
    private float extension = -1.0f;
    private Rotation relativeExtractDir = Rotation.CLOCKWISE_180;

    public ExtractConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        int i;
        float extend;
        TextureAtlasSprite texture_steel = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/metal/storage_steel"));
        TextureAtlasSprite texture_casing = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/wooden_device/turntable_bottom"));
        TextureAtlasSprite texture_curtain = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/stripcurtain"));
        TextureAtlasSprite texture_assembler = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/multiblocks/assembler"));
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(this.getExtractDirection());
        TransformationMatrix tMatrix = matrix.toTransformationMatrix();
        this.extension = extend = this.getExtensionIntoBlock(this.getTile());
        Function<Direction, TextureAtlasSprite> getCasingSprite = enumFacing -> enumFacing.func_176740_k() == Direction.Axis.Z ? texture_steel : texture_casing;
        Function<Vec3d[], Vec3d[]> vertexTransformer = vertices -> {
            if (extend == 0.0f) {
                return vertices;
            }
            Vec3d[] ret = new Vec3d[((Vec3d[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3d(vertices[i].field_72450_a, vertices[i].field_72448_b, vertices[i].field_72449_c - (double)extend);
            }
            return ret;
        };
        Function<Vec3d[], Vec3d[]> casingTransformer = vertices -> {
            Vec3d[] ret = new Vec3d[((Vec3d[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3d(vertices[i].field_72450_a, vertices[i].field_72448_b - 0.25, vertices[i].field_72449_c - 0.625 - (double)extend);
            }
            return ret;
        };
        baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0625, 0.375, 0.625), new Vec3d(0.1875, 1.0, 1.0), matrix, this.getFacing(), casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.8125, 0.375, 0.625), new Vec3d(0.9375, 1.0, 1.0), matrix, this.getFacing(), casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.1875, 0.875, 0.625), new Vec3d(0.8125, 1.0, 1.0), matrix, this.getFacing(), casingTransformer, getCasingSprite, colour));
        if (this.getTile() != null && extend > 0.0f) {
            TextureAtlasSprite tex_conveyor = ClientUtils.getSprite(this.isActive() ? BasicConveyor.texture_on : BasicConveyor.texture_off);
            Function<Direction, TextureAtlasSprite> getExtensionSprite = enumFacing -> enumFacing.func_176740_k() == Direction.Axis.Y ? null : (enumFacing.func_176740_k() == Direction.Axis.Z ? texture_steel : texture_casing);
            Vec3d[] vertices2 = new Vec3d[]{new Vec3d(0.0625, 0.0, (double)(-extend)), new Vec3d(0.0625, 0.0, 0.0), new Vec3d(0.9375, 0.0, 0.0), new Vec3d(0.9375, 0.0, (double)(-extend))};
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices2), Utils.rotateFacingTowardsDir(Direction.DOWN, this.getFacing()), tex_conveyor, new double[]{15.0, extend * 16.0f, 1.0, 0.0}, colour, true));
            for (int i2 = 0; i2 < vertices2.length; ++i2) {
                vertices2[i2] = Utils.withCoordinate(vertices2[i2], Direction.Axis.Y, 0.125);
            }
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices2), Utils.rotateFacingTowardsDir(Direction.UP, this.getFacing()), tex_conveyor, new double[]{15.0, (1.0f - extend) * 16.0f, 1.0, 16.0}, colour, false));
            baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0625, 0.25, 0.625), new Vec3d(0.9375, 0.375, (double)(0.625f + extend)), matrix, this.getFacing(), casingTransformer, getExtensionSprite, colour));
        }
        Vec3d[] vertices3 = new Vec3d[]{new Vec3d(0.8125, 0.625, 0.03125), new Vec3d(0.8125, 0.125, 0.03125), new Vec3d(0.1875, 0.125, 0.03125), new Vec3d(0.1875, 0.625, 0.03125)};
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(Direction.NORTH, this.getFacing()), texture_assembler, new double[]{15.25, 13.25, 12.75, 15.25}, colour, false));
        for (i = 0; i < vertices3.length; ++i) {
            vertices3[i] = Utils.withCoordinate(vertices3[i], Direction.Axis.Z, 0.0625);
        }
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(Direction.SOUTH, this.getFacing()), texture_assembler, new double[]{12.75, 13.25, 15.25, 15.25}, colour, true));
        for (i = 0; i < 5; ++i) {
            float off = (float)i * 0.125f;
            baseModel.addAll(ClientUtils.createBakedBox(new Vec3d((double)(0.203125f + off), 0.1875, 0.09375), new Vec3d((double)(0.296875f + off), 0.625, 0.125), matrix, this.getFacing(), vertexTransformer, facing1 -> texture_curtain, colour));
        }
        super.modifyQuads(baseModel);
        return baseModel;
    }

    @Override
    public String getModelCacheKey() {
        String key = super.getModelCacheKey();
        key = key + "e" + this.getExtractDirection().ordinal();
        key = key + "ex" + this.getExtensionIntoBlock(this.getTile());
        return key;
    }

    @Override
    public boolean renderWall(Direction facing, int wall) {
        Direction side = wall == 0 ? facing.func_176735_f() : facing.func_176746_e();
        return side != this.getExtractDirection() && super.renderWall(facing, wall);
    }

    private float getExtensionIntoBlock(TileEntity tile) {
        BlockPos neighbour;
        float extend = 0.0f;
        if (tile == null || !tile.func_145830_o()) {
            return extend;
        }
        World world = tile.func_145831_w();
        if (!world.func_175623_d(neighbour = tile.func_174877_v().func_177972_a(this.getExtractDirection()))) {
            BlockState connected = world.func_180495_p(neighbour);
            TileEntity connectedTile = world.func_175625_s(neighbour);
            if (connectedTile != null && connectedTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getExtractDirection().func_176734_d()).isPresent() && Block.func_208061_a((VoxelShape)connected.func_196954_c((IBlockReader)world, neighbour), (Direction)this.getExtractDirection().func_176734_d())) {
                AxisAlignedBB aabb = connected.func_196954_c((IBlockReader)world, neighbour).func_197752_a();
                switch (this.getExtractDirection()) {
                    case NORTH: {
                        extend = (float)(1.0 - aabb.field_72334_f);
                        break;
                    }
                    case SOUTH: {
                        extend = (float)aabb.field_72339_c;
                        break;
                    }
                    case WEST: {
                        extend = (float)(1.0 - aabb.field_72336_d);
                        break;
                    }
                    case EAST: {
                        extend = (float)aabb.field_72340_a;
                    }
                }
                if (extend > 0.25f) {
                    return 0.25f;
                }
                float round = extend % 0.0625f;
                if (round < extend) {
                    extend = round + 0.0625f;
                }
            }
        }
        return extend;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    private boolean isPowered(TileEntity tile) {
        return tile.func_145831_w().func_175687_A(tile.func_174877_v()) > 0;
    }

    @Override
    public boolean isTicking() {
        return true;
    }

    @Override
    public void onUpdate() {
        if (!this.getTile().func_145831_w().field_72995_K) {
            BlockPos neighbour;
            World world;
            if (this.transferCooldown > 0) {
                --this.transferCooldown;
            }
            if (!this.isPowered(this.getTile()) && this.transferCooldown <= 0 && !(world = this.getTile().func_145831_w()).func_175623_d(neighbour = this.getTile().func_174877_v().func_177972_a(this.getExtractDirection()))) {
                LazyOptional<IItemHandler> cap = ApiUtils.findItemHandlerAtPos(world, neighbour, this.getExtractDirection().func_176734_d(), true);
                cap.ifPresent(itemHandler -> {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack extractItem = itemHandler.extractItem(i, 1, true);
                        if (extractItem.func_190926_b()) continue;
                        extractItem = itemHandler.extractItem(i, 1, false);
                        ItemEntity entity = new ItemEntity(world, (double)this.getTile().func_174877_v().func_177958_n() + 0.5, (double)this.getTile().func_174877_v().func_177956_o() + 0.1875, (double)this.getTile().func_174877_v().func_177952_p() + 0.5, extractItem);
                        entity.func_213317_d(Vec3d.field_186680_a);
                        world.func_217376_c((Entity)entity);
                        this.onItemDeployed(entity);
                        this.transferCooldown = this.transferTickrate;
                        return;
                    }
                });
            }
        }
    }

    @Override
    public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (super.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        if (Utils.isHammer(heldItem) && player.func_225608_bj_()) {
            do {
                this.relativeExtractDir = Rotation.values()[(this.relativeExtractDir.ordinal() + 1) % Rotation.values().length];
            } while (this.relativeExtractDir == Rotation.NONE);
            return true;
        }
        if (Utils.isScrewdriver(heldItem)) {
            if (this.transferTickrate == 4) {
                this.transferTickrate = 8;
            } else if (this.transferTickrate == 8) {
                this.transferTickrate = 16;
            } else if (this.transferTickrate == 16) {
                this.transferTickrate = 20;
            } else if (this.transferTickrate == 20) {
                this.transferTickrate = 4;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.tickrate", new Object[]{this.transferTickrate}), true);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getSelectionShape() {
        VoxelShape ret = conveyorBounds;
        if (this.extension < 0.0f) {
            this.extension = this.getExtensionIntoBlock(this.getTile());
        }
        VoxelShape extensionShape = null;
        switch (this.getExtractDirection()) {
            case NORTH: {
                extensionShape = VoxelShapes.func_197873_a((double)0.0625, (double)0.125, (double)(-this.extension), (double)0.9375, (double)0.75, (double)(0.375 - (double)this.extension));
                break;
            }
            case SOUTH: {
                extensionShape = VoxelShapes.func_197873_a((double)0.0625, (double)0.125, (double)(0.625 + (double)this.extension), (double)0.9375, (double)0.75, (double)(1.0f + this.extension));
                break;
            }
            case WEST: {
                extensionShape = VoxelShapes.func_197873_a((double)(-this.extension), (double)0.125, (double)0.0625, (double)(0.375 - (double)this.extension), (double)0.75, (double)0.9375);
                break;
            }
            case EAST: {
                extensionShape = VoxelShapes.func_197873_a((double)(0.625 + (double)this.extension), (double)0.125, (double)0.0625, (double)(1.0f + this.extension), (double)0.75, (double)0.9375);
            }
        }
        if (extensionShape != null) {
            ret = VoxelShapes.func_197878_a((VoxelShape)ret, extensionShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return ret;
    }

    @Override
    public CompoundNBT writeConveyorNBT() {
        CompoundNBT nbt = super.writeConveyorNBT();
        nbt.func_74768_a("transferCooldown", this.transferCooldown);
        nbt.func_74768_a("transferTickrate", this.transferTickrate);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundNBT nbt) {
        super.readConveyorNBT(nbt);
        this.transferCooldown = nbt.func_74762_e("transferCooldown");
        this.transferTickrate = nbt.func_74762_e("transferTickrate");
    }

    private Direction getExtractDirection() {
        return this.relativeExtractDir.func_185831_a(this.getFacing());
    }
}

