/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ThermoelectricGenTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.INeighbourChangeTile,
EnergyHelper.IIEInternalFluxConnector {
    public static TileEntityType<ThermoelectricGenTileEntity> TYPE;
    private int energyOutput = -1;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);

    public ThermoelectricGenTileEntity() {
        super(TYPE);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 1024L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x3FF)) {
                this.recalculateEnergyOutput();
            }
            if (this.energyOutput > 0) {
                this.outputEnergy(this.energyOutput);
            }
        }
    }

    public void outputEnergy(int amount) {
        for (Direction fd : Direction.field_199792_n) {
            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(fd));
            amount -= EnergyHelper.insertFlux((ICapabilityProvider)te, fd.func_176734_d(), amount, false);
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        this.recalculateEnergyOutput();
    }

    private void recalculateEnergyOutput() {
        int energy = 0;
        for (Direction fd : new Direction[]{Direction.DOWN, Direction.NORTH, Direction.WEST}) {
            if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd)) || this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd.func_176734_d()))) continue;
            int temp0 = this.getTemperature(this.func_174877_v().func_177972_a(fd));
            int temp1 = this.getTemperature(this.func_174877_v().func_177972_a(fd.func_176734_d()));
            if (temp0 <= -1 || temp1 <= -1) continue;
            int diff = Math.abs(temp0 - temp1);
            energy += (int)(Math.sqrt(diff) / 2.0 * (Double)IEConfig.MACHINES.thermoelectric_output.get());
        }
        this.energyOutput = energy == 0 ? -1 : energy;
    }

    private int getTemperature(BlockPos pos) {
        Fluid f = this.getFluid(pos);
        if (f != Fluids.field_204541_a) {
            return f.getAttributes().getTemperature((ILightReader)this.field_145850_b, pos);
        }
        BlockState state = this.field_145850_b.func_180495_p(pos);
        return ThermoelectricHandler.getTemperature(state.func_177230_c());
    }

    @Nullable
    Fluid getFluid(BlockPos pos) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        IFluidState fState = state.func_204520_s();
        return fState.func_206886_c();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyOutput = nbt.func_74762_e("enegyOutput");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("enegyOutput", this.energyOutput);
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public boolean canConnectEnergy(Direction from) {
        return true;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        return this.wrapper;
    }
}

