/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.MiscConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.PostTransformerTileEntity;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class PostTransformerBlock
extends MiscConnectorBlock {
    public PostTransformerBlock() {
        super("post_transformer", () -> PostTransformerTileEntity.TYPE, (List<IProperty<?>>)ImmutableList.of((Object)IEProperties.FACING_HORIZONTAL), (Block b, Item.Properties p) -> null);
    }

    public Item func_199767_j() {
        return IEBlocks.Connectors.transformer.func_199767_j();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState baseState = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.stateForPos(baseState, currentPos, (IBlockReader)worldIn, Blocks.field_150350_a.func_176223_P());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState baseState = super.func_196258_a(context);
        return this.stateForPos(baseState, context.func_195995_a(), (IBlockReader)context.func_195991_k(), null);
    }

    private BlockState stateForPos(@Nullable BlockState baseState, BlockPos pos, IBlockReader world, BlockState empty) {
        if (baseState == null || baseState.func_177230_c() != this) {
            return empty;
        }
        Direction preferred = (Direction)baseState.func_177229_b((IProperty)IEProperties.FACING_HORIZONTAL);
        Optional<Direction> newFacing = PostTransformerBlock.findAttacheablePost(pos, world, preferred);
        if (newFacing.isPresent()) {
            return (BlockState)baseState.func_206870_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)newFacing.get());
        }
        return empty;
    }

    private static Optional<Direction> findAttacheablePost(BlockPos transformerPos, IBlockReader world, Direction preferred) {
        Optional<Direction> ret = Optional.empty();
        for (Direction d : Direction.field_176754_o) {
            if (!PostTransformerBlock.isAttacheablePost(transformerPos.func_177972_a(d), world)) continue;
            ret = Optional.of(d);
            if (d == preferred) break;
        }
        return ret;
    }

    public static boolean isAttacheablePost(BlockPos possiblePost, IBlockReader w) {
        BlockState postState = w.func_180495_p(possiblePost);
        if (!(postState.func_177230_c() instanceof IPostBlock)) {
            return false;
        }
        IPostBlock post = (IPostBlock)postState.func_177230_c();
        return post.canConnectTransformer(w, possiblePost);
    }
}

