/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.shapes.CachedShapesWithTransform;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class DieselGeneratorTileEntity
extends MultiblockPartTileEntity<DieselGeneratorTileEntity>
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ISoundTile {
    public static TileEntityType<DieselGeneratorTileEntity> TYPE;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public boolean active = false;
    public float animation_fanRotationStep = 0.0f;
    public float animation_fanRotation = 0.0f;
    public int animation_fanFadeIn = 0;
    public int animation_fanFadeOut = 0;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES;

    public DieselGeneratorTileEntity() {
        super(IEMultiblocks.DIESEL_GENERATOR, TYPE, true);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.active = nbt.func_74767_n("active");
        this.animation_fanRotation = nbt.func_74760_g("animation_fanRotation");
        this.animation_fanFadeIn = nbt.func_74762_e("animation_fanFadeIn");
        this.animation_fanFadeOut = nbt.func_74762_e("animation_fanFadeOut");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_74757_a("active", this.active);
        nbt.func_74776_a("animation_fanRotation", this.animation_fanRotation);
        nbt.func_74768_a("animation_fanFadeIn", this.animation_fanFadeIn);
        nbt.func_74768_a("animation_fanFadeOut", this.animation_fanFadeOut);
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.isDummy()) {
            return;
        }
        if (this.active || this.animation_fanFadeIn > 0 || this.animation_fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = this.active ? base : 0.0f;
            if (this.animation_fanFadeIn > 0) {
                step -= (float)this.animation_fanFadeIn / 80.0f * base;
                --this.animation_fanFadeIn;
            }
            if (this.animation_fanFadeOut > 0) {
                step += (float)this.animation_fanFadeOut / 80.0f * base;
                --this.animation_fanFadeOut;
            }
            this.animation_fanRotationStep = step;
            this.animation_fanRotation += step;
            this.animation_fanRotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, this, this.active, 0.5f, 1.0f);
            if (this.active && this.field_145850_b.func_82737_E() % 4L == 0L) {
                BlockPos exhaust = this.getBlockPosForPos(new BlockPos(2, 2, 2));
                Direction fl = this.getFacing();
                Direction fw = this.getFacing().func_176746_e();
                if (this.getIsMirrored()) {
                    fw = fw.func_176734_d();
                }
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, (double)exhaust.func_177958_n() + 0.5 + (double)((float)fl.func_82601_c() * 0.3125f) + (double)((float)(-fw.func_82601_c()) * 0.3125f), (double)exhaust.func_177956_o() + 1.25, (double)exhaust.func_177952_p() + 0.5 + (double)((float)fl.func_82599_e() * 0.3125f) + (double)((float)(-fw.func_82599_e()) * 0.3125f), 0.015625 - 0.03125 * Math.random(), 0.0625, 0.015625 - 0.03125 * Math.random());
            }
        } else {
            boolean prevActive = this.active;
            if (!this.isRSDisabled() && !this.tanks[0].getFluid().isEmpty()) {
                int burnTime = DieselHandler.getBurnTime(this.tanks[0].getFluid().getFluid());
                if (burnTime > 0) {
                    int fluidConsumed = 1000 / burnTime;
                    int output = (Integer)IEConfig.MACHINES.dieselGen_output.get();
                    int connected = 0;
                    TileEntity[] receivers = new TileEntity[3];
                    for (int i = 0; i < 3; ++i) {
                        receivers[i] = this.getEnergyOutput(i == 1 ? -1 : (i == 2 ? 1 : 0));
                        if (receivers[i] == null || EnergyHelper.insertFlux((ICapabilityProvider)receivers[i], Direction.DOWN, 4096, true) <= 0) continue;
                        ++connected;
                    }
                    if (connected > 0 && this.tanks[0].getFluidAmount() >= fluidConsumed) {
                        if (!this.active) {
                            this.active = true;
                            this.animation_fanFadeIn = 80;
                        }
                        this.tanks[0].drain(fluidConsumed, IFluidHandler.FluidAction.EXECUTE);
                        int splitOutput = output / connected;
                        int leftover = output % connected;
                        for (int i = 0; i < 3; ++i) {
                            if (receivers[i] == null) continue;
                            EnergyHelper.insertFlux((ICapabilityProvider)receivers[i], Direction.DOWN, splitOutput + (leftover-- > 0 ? 1 : 0), false);
                        }
                    } else if (this.active) {
                        this.active = false;
                        this.animation_fanFadeOut = 80;
                    }
                }
            } else if (this.active) {
                this.active = false;
                this.animation_fanFadeOut = 80;
            }
            if (prevActive != this.active) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Nullable
    TileEntity getEnergyOutput(int w) {
        BlockPos outPos = this.getBlockPosForPos(new BlockPos(1 + w, 1, 4)).func_177982_a(0, 1, 0);
        TileEntity eTile = Utils.getExistingTileEntity(this.field_145850_b, outPos);
        if (EnergyHelper.isFluxReceiver((ICapabilityProvider)eTile, Direction.DOWN)) {
            return eTile;
        }
        return null;
    }

    public static AxisAlignedBB getBlockBounds(BlockPos posInMultiblock) {
        boolean lessThan21;
        if (new BlockPos(1, 0, 4).equals((Object)posInMultiblock)) {
            return new AxisAlignedBB(0.0, 0.5, -0.625, 1.0, 1.5, 1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 4), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, posInMultiblock.func_177956_o() == 2 ? 0.8125 : 1.0, posInMultiblock.func_177952_p() == 0 ? 1.125 : 1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(0, 2, 0)).contains((Object)posInMultiblock)) {
            return new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, posInMultiblock.func_177956_o() == 2 ? 0.8125 : 1.0, posInMultiblock.func_177952_p() == 0 ? 1.125 : 1.0);
        }
        if (new BlockPos(1, 2, 0).equals((Object)posInMultiblock)) {
            posInMultiblock.func_177952_p();
            posInMultiblock.func_177952_p();
            posInMultiblock.func_177952_p();
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, posInMultiblock.func_177956_o() == 2 ? 0.8125 : 1.0, posInMultiblock.func_177952_p() == 0 ? 0.625 : 1.0);
        }
        if (posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177952_p() == 4) {
            return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
        if (posInMultiblock.func_177958_n() == 1 && posInMultiblock.func_177956_o() > 0 && posInMultiblock.func_177952_p() == 3) {
            return new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, posInMultiblock.func_177956_o() == 2 ? 0.3125 : 1.0, 0.625);
        }
        if (new MutableBoundingBox(1, 2, 1, 1, 2, 2).func_175898_b((Vec3i)posInMultiblock)) {
            return new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.3125, 1.0);
        }
        if (posInMultiblock.func_177958_n() % 2 == 0 && posInMultiblock.func_177956_o() == 0) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        }
        boolean bl = lessThan21 = posInMultiblock.func_177956_o() == 0 || posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177952_p() > 2;
        if (posInMultiblock.func_177958_n() == 0 && posInMultiblock.func_177956_o() < 2) {
            return new AxisAlignedBB(0.9375, -0.5, 0.0, 1.0, 0.625, lessThan21 ? 0.625 : 1.0);
        }
        if (posInMultiblock.func_177958_n() == 2 && posInMultiblock.func_177956_o() < 2) {
            return new AxisAlignedBB(0.0, -0.5, 0.0, 0.0625, 0.625, lessThan21 ? 0.625 : 1.0);
        }
        if (posInMultiblock.func_177958_n() % 2 == 0 && posInMultiblock.func_177956_o() == 2 && posInMultiblock.func_177952_p() == 2) {
            return Utils.flipBox(false, posInMultiblock.func_177958_n() == 2, new AxisAlignedBB(0.5625, 0.0, -0.0625, 1.0625, posInMultiblock.func_177958_n() == 2 ? 1.125 : 0.75, 0.4375));
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public VoxelShape getBlockBounds() {
        return CachedShapesWithTransform.get(SHAPES, this);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(1, 1, 4).equals((Object)posInMultiblock)) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, -0.5, -0.625, 1.0, 0.5, 1.0)});
        }
        if (posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177952_p() == 4) {
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 2, new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.125, 0.0, 0.125, 0.375, 0.5, 0.375), new AxisAlignedBB(0.125, 0.0, 0.625, 0.375, 0.5, 0.875));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)DieselGeneratorTileEntity.getBlockBounds(posInMultiblock), (Object)new AxisAlignedBB(0.5, 0.25, 0.3125, 1.0, 0.75, 0.6875), (Object)new AxisAlignedBB(0.6875, -0.5, 0.4375, 0.8125, 0.25, 0.5625));
        }
        if (posInMultiblock.func_177958_n() % 2 == 0 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177952_p() < 4) {
            double offset;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{DieselGeneratorTileEntity.getBlockBounds(posInMultiblock)});
            if (posInMultiblock.func_177952_p() > 2) {
                list.add(new AxisAlignedBB(0.125, 0.5625, 0.25, 1.0, 0.8125, 0.5));
                list.add(new AxisAlignedBB(0.125, 0.5625, 0.5, 0.375, 0.8125, 1.0));
            } else if (posInMultiblock.func_177952_p() > 0) {
                offset = posInMultiblock.func_177952_p() > 1 ? 0.0 : 1.0;
                list.add(new AxisAlignedBB(0.4375, 0.5, -0.5625 + offset, 1.0, 1.0, 0.75 + offset));
            }
            if (posInMultiblock.func_177952_p() < 2) {
                offset = posInMultiblock.func_177952_p() == 1 ? 0.0 : 1.0;
                list.add(new AxisAlignedBB(0.375, 0.5625, 0.5625 + offset, 0.4375, 0.8125, 0.8125 + offset));
                list.add(new AxisAlignedBB(0.375, 0.5625, -0.875 + offset, 0.5, 0.8125, -0.625 + offset));
                list.add(new AxisAlignedBB(0.125, 0.5625, -0.875 + offset, 0.375, 0.8125, 0.8125 + offset));
            }
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 2, list);
        }
        return ImmutableList.of((Object)DieselGeneratorTileEntity.getBlockBounds(posInMultiblock));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        DieselGeneratorTileEntity master = (DieselGeneratorTileEntity)this.master();
        if (master != null && this.posInMultiblock.func_177952_p() == 4 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177958_n() % 2 == 0 && (side == null || side.func_176740_k() == this.getFacing().func_176735_f().func_176740_k())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        if (resources == null) {
            return false;
        }
        return DieselHandler.isValidFuel(resources.getFluid());
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.active;
    }

    @Override
    public float getSoundRadiusSq() {
        return 1024.0f;
    }

    static {
        SHAPES = CachedShapesWithTransform.createForMultiblock(DieselGeneratorTileEntity::getShape);
    }
}

