/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IETileProviderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ConveyorBlock
extends IETileProviderBlock {
    private final ResourceLocation typeName;
    public static final EnumProperty<Direction> FACING = IEProperties.FACING_HORIZONTAL;

    public ConveyorBlock(ResourceLocation type) {
        super(ConveyorHandler.getRegistryNameFor(type).func_110623_a(), Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 15.0f).func_226896_b_(), BlockItemIE::new, new IProperty[]{FACING});
        this.typeName = type;
        this.lightOpacity = 0;
        ConveyorHandler.conveyorBlocks.put(type, this);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        String flavourKey = this.func_149739_a() + ".flavour";
        if (I18n.func_188566_a((String)flavourKey)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(flavourKey, new Object[0]));
        }
    }

    @Override
    public void onIEBlockPlacedBy(BlockItemUseContext context, BlockState state) {
        super.onIEBlockPlacedBy(context, state);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ConveyorBeltTileEntity) {
            ConveyorBeltTileEntity conveyor = (ConveyorBeltTileEntity)tile;
            Direction f = conveyor.getFacing();
            tile = world.func_175625_s(pos.func_177972_a(f));
            TileEntity tileUp = world.func_175625_s(pos.func_177972_a(f).func_177982_a(0, 1, 0));
            ConveyorHandler.IConveyorBelt subType = conveyor.getConveyorSubtype();
            if (subType != null && (!(tile instanceof ConveyorHandler.IConveyorTile) || ((ConveyorHandler.IConveyorTile)tile).getFacing() == f.func_176734_d()) && tileUp instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)tileUp).getFacing() != f.func_176734_d() && world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                subType.setConveyorDirection(ConveyorHandler.ConveyorDirection.UP);
            }
        }
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new ConveyorBeltTileEntity(this.typeName);
    }

    @Override
    public boolean allowHammerHarvest(BlockState blockState) {
        return true;
    }

    public ResourceLocation getTypeName() {
        return this.typeName;
    }
}

