/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;

public class ConnectorProbeTileEntity
extends ConnectorRedstoneTileEntity {
    private DyeColor redstoneChannelSending = DyeColor.WHITE;
    private int lastOutput = 0;
    public static TileEntityType<ConnectorProbeTileEntity> TYPE;

    public ConnectorProbeTileEntity() {
        super((TileEntityType<? extends ConnectorRedstoneTileEntity>)TYPE);
    }

    @Override
    public void func_73660_a() {
        int out;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 8L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 8) && (out = this.getComparatorSignal()) != this.lastOutput) {
            this.lastOutput = out;
            this.rsDirty = true;
        }
        super.func_73660_a();
    }

    @Override
    public boolean isRSInput() {
        return true;
    }

    @Override
    public boolean isRSOutput() {
        return true;
    }

    private int getComparatorSignal() {
        BlockPos pos = this.func_174877_v().func_177972_a(this.getFacing());
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_185912_n()) {
            return state.func_185888_a(this.field_145850_b, pos);
        }
        if (state.func_215686_e((IBlockReader)this.field_145850_b, pos)) {
            ItemFrameEntity entityitemframe;
            state = this.field_145850_b.func_180495_p(pos = pos.func_177972_a(this.getFacing()));
            if (state.func_185912_n()) {
                return state.func_185888_a(this.field_145850_b, pos);
            }
            if (state.func_185904_a() == Material.field_151579_a && (entityitemframe = this.findItemFrame(this.field_145850_b, this.getFacing(), pos)) != null) {
                return entityitemframe.func_174866_q();
            }
        }
        return 0;
    }

    private ItemFrameEntity findItemFrame(World world, Direction facing, BlockPos pos) {
        List list = world.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB(pos), entity -> entity != null && entity.func_174811_aO() == facing);
        return list.size() == 1 ? (ItemFrameEntity)list.get(0) : null;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        signals[this.redstoneChannelSending.ordinal()] = (byte)Math.max(this.lastOutput, signals[this.redstoneChannelSending.ordinal()]);
        this.rsDirty = false;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.redstoneChannel = DyeColor.func_196056_a((int)(this.redstoneChannel.func_196059_a() + 1));
            } else {
                this.redstoneChannelSending = DyeColor.func_196056_a((int)(this.redstoneChannelSending.func_196059_a() + 1));
            }
            this.func_70296_d();
            this.globalNet.getLocalNet(this.field_174879_c).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 254, 0);
        }
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("redstoneChannelSending", this.redstoneChannelSending.func_196059_a());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.redstoneChannelSending = DyeColor.func_196056_a((int)nbt.func_74762_e("redstoneChannelSending"));
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double conRadius = con.type.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.375 - conRadius), 0.5 + (double)side.func_96559_d() * (0.375 - conRadius), 0.5 + (double)side.func_82599_e() * (0.375 - conRadius));
    }

    @Override
    public VoxelShape getBlockBounds() {
        float wMin = 0.28125f;
        float wMax = 0.71875f;
        switch (this.getFacing().func_176734_d()) {
            case UP: 
            case DOWN: {
                return VoxelShapes.func_197873_a((double)wMin, (double)0.0, (double)wMin, (double)wMax, (double)1.0, (double)wMax);
            }
            case SOUTH: 
            case NORTH: {
                return VoxelShapes.func_197873_a((double)wMin, (double)wMin, (double)0.0, (double)wMax, (double)wMax, (double)1.0);
            }
            case EAST: 
            case WEST: {
                return VoxelShapes.func_197873_a((double)0.0, (double)wMin, (double)wMin, (double)1.0, (double)wMax, (double)wMax);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(BlockState object, String group) {
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_();
        }
        return MinecraftForgeClient.getRenderLayer() == RenderType.func_228639_c_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector4f getRenderColor(BlockState object, String group, Vector4f original) {
        if ("colour_in".equals(group)) {
            float[] rgb = this.redstoneChannel.func_193349_f();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        if ("colour_out".equals(group)) {
            float[] rgb = this.redstoneChannelSending.func_193349_f();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    @Override
    public String getCacheKey(BlockState object) {
        return this.redstoneChannel + ";" + this.redstoneChannelSending;
    }

    @Override
    public String[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel.rec", (Object[])new Object[]{I18n.func_135052_a((String)("item.minecraft.firework_star." + this.redstoneChannel.func_176762_d()), (Object[])new Object[0])}), I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel.send", (Object[])new Object[]{I18n.func_135052_a((String)("item.minecraft.firework_star." + this.redstoneChannelSending.func_176762_d()), (Object[])new Object[0])})};
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }
}

