/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChargingStationTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IPlayerInteraction {
    public static TileEntityType<ChargingStationTileEntity> TYPE;
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(32000);
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private boolean charging = true;
    public int comparatorOutput = 0;
    EnergyHelper.IEForgeEnergyWrapper wrapperDown = new EnergyHelper.IEForgeEnergyWrapper(this, Direction.DOWN);
    EnergyHelper.IEForgeEnergyWrapper wrapperDir = null;
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(1, this));

    public ChargingStationTileEntity() {
        super(TYPE);
    }

    public void func_73660_a() {
        float max;
        if (EnergyHelper.isFluxReceiver((ICapabilityProvider)this.inventory.get(0))) {
            if (this.field_145850_b.field_72995_K && this.charging) {
                float charge = 0.0f;
                max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0));
                if (max > 0.0f) {
                    charge = (float)EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0)) / max;
                }
                for (int i = 0; i < 3; ++i) {
                    long time = this.field_145850_b.func_82737_E();
                    if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                    int shift = i - 1;
                    double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (this.getFacing() == Direction.WEST ? -0.46875 : (this.getFacing() == Direction.EAST ? 0.46875 : (this.getFacing() == Direction.NORTH ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    double y = (double)this.func_174877_v().func_177956_o() + 0.25;
                    double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (this.getFacing() == Direction.NORTH ? -0.46875 : (this.getFacing() == Direction.SOUTH ? 0.46875 : (this.getFacing() == Direction.EAST ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_145850_b, x, y, z, 0.25, 0.25, 0.25, 0.5f, 1.0f - charge, charge, 0.0f);
                }
            } else if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0));
                int max2 = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0));
                int space = max2 - stored;
                if (space > 0) {
                    int energyDecNew;
                    int energyDec = 10 * stored / max2;
                    int insert = Math.min(space, Math.max(this.energyStorage.getAverageInsertion(), (Integer)IEConfig.MACHINES.charger_consumption.get()));
                    int accepted = Math.min(EnergyHelper.insertFlux((ICapabilityProvider)this.inventory.get(0), insert, true), this.energyStorage.extractEnergy(insert, true));
                    if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                        stored += EnergyHelper.insertFlux((ICapabilityProvider)this.inventory.get(0), accepted, false);
                    }
                    if (energyDec != (energyDecNew = 10 * stored / max2)) {
                        this.markContainingBlockForUpdate(null);
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.markContainingBlockForUpdate(null);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F)) {
            int i;
            float charge = 0.0f;
            if (EnergyHelper.isFluxReceiver((ICapabilityProvider)this.inventory.get(0)) && (max = (float)EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0))) > 0.0f) {
                charge = (float)EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0)) / max;
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.inventory.set(0, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inventory")));
        this.charging = nbt.func_74767_n("charging");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74757_a("charging", this.charging);
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            nbt.func_218657_a("inventory", (INBT)((ItemStack)this.inventory.get(0)).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return facing == Direction.DOWN || facing == this.getFacing().func_176734_d() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing == Direction.DOWN) {
            return this.wrapperDown;
        }
        if (facing == this.getFacing().func_176734_d()) {
            if (this.wrapperDir == null || this.wrapperDir.side != this.getFacing().func_176734_d()) {
                this.wrapperDir = new EnergyHelper.IEForgeEnergyWrapper(this, this.getFacing().func_176734_d());
            }
            return this.wrapperDir;
        }
        return null;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public VoxelShape getBlockBounds() {
        return VoxelShapes.func_197873_a((double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.0 : 0.125), (double)0.0, (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.0 : 0.125), (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 1.0 : 0.875), (double)1.0, (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 1.0 : 0.875));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return EnergyHelper.isFluxReceiver((ICapabilityProvider)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.isStackValid(0, heldItem)) {
            ItemStack stored = !((ItemStack)this.inventory.get(0)).func_190926_b() ? ((ItemStack)this.inventory.get(0)).func_77946_l() : ItemStack.field_190927_a;
            this.inventory.set(0, (Object)heldItem.func_77946_l());
            player.func_184611_a(hand, stored);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_70099_a(((ItemStack)this.inventory.get(0)).func_77946_l(), 0.5f);
            }
            this.inventory.set(0, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }
}

