/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.network.PacketDistributor;

public class BucketWheelTileEntity
extends MultiblockPartTileEntity<BucketWheelTileEntity>
implements IOBJModelCallback<BlockState>,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<BucketWheelTileEntity> TYPE;
    public float rotation = 0.0f;
    public final NonNullList<ItemStack> digStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public boolean active = false;
    public ItemStack particleStack = ItemStack.field_190927_a;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;

    public BucketWheelTileEntity() {
        super(IEMultiblocks.BUCKET_WHEEL, TYPE, false);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        float nbtRot = nbt.func_74760_g("rotation");
        this.rotation = (double)Math.abs(nbtRot - this.rotation) > 5.0 * (Double)IEConfig.MACHINES.excavator_speed.get() ? nbtRot : this.rotation;
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.digStacks);
        this.active = nbt.func_74767_n("active");
        this.particleStack = nbt.func_150297_b("particleStack", 10) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("particleStack")) : ItemStack.field_190927_a;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("rotation", this.rotation);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.digStacks);
        nbt.func_74757_a("active", this.active);
        if (!this.particleStack.func_190926_b()) {
            nbt.func_218657_a("particleStack", (INBT)this.particleStack.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.formed || !new BlockPos(3, 3, 0).equals((Object)this.posInMultiblock)) {
            return;
        }
        if (this.active) {
            this.rotation = (float)((double)this.rotation + (Double)IEConfig.MACHINES.excavator_speed.get());
            this.rotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.particleStack.func_190926_b()) {
                ImmersiveEngineering.proxy.spawnBucketWheelFX(this, this.particleStack);
                this.particleStack = ItemStack.field_190927_a;
            }
        } else if (this.active && this.field_145850_b.func_82737_E() % 20L == 0L) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("rotation", this.rotation);
            MessageTileSync sync = new MessageTileSync(this, nbt);
            ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)sync);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(BlockState object, String group, String material) {
        int index;
        if (group.startsWith("dig") && !((ItemStack)this.digStacks.get(index = Integer.parseInt(group.substring(3)))).func_190926_b()) {
            ResourceLocation rl = null;
            BlockState state = Utils.getStateFromItemStack((ItemStack)this.digStacks.get(index));
            rl = state != null ? ClientUtils.getSideTexture(state, Direction.UP) : ClientUtils.getSideTexture((ItemStack)this.digStacks.get(index), Direction.UP);
            if (rl != null) {
                return ClientUtils.getSprite(rl);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(CompoundNBT message) {
        NonNullList<ItemStack> nonNullList = this.digStacks;
        synchronized (nonNullList) {
            int packetRotation;
            if (message.func_150297_b("fill", 3)) {
                this.digStacks.set(message.func_74762_e("fill"), (Object)ItemStack.func_199557_a((CompoundNBT)message.func_74775_l("fillStack")));
            }
            if (message.func_150297_b("empty", 3)) {
                int toRemove = message.func_74762_e("empty");
                this.particleStack = (ItemStack)this.digStacks.get(toRemove);
                this.digStacks.set(toRemove, (Object)ItemStack.field_190927_a);
            }
            if (message.func_150297_b("rotation", 3) && (double)Math.abs((float)(packetRotation = message.func_74762_e("rotation")) - this.rotation) > 5.0 * (Double)IEConfig.MACHINES.excavator_speed.get()) {
                this.rotation = packetRotation;
            }
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0), -3, -(this.getFacing().func_176740_k() == Direction.Axis.X ? 3 : 0)), this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 4 : 1, 4, this.getFacing().func_176740_k() == Direction.Axis.X ? 4 : 1));
        }
        return this.renderAABB;
    }

    @Override
    public VoxelShape getBlockBounds() {
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(4, 1, 0)).contains((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 6, 0), (Object)new BlockPos(2, 5, 0), (Object)new BlockPos(4, 5, 0)).contains((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
        }
        if (new BlockPos(0, 3, 0).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)(this.getFacing() == Direction.NORTH ? 0.25 : 0.0), (double)0.0, (double)(this.getFacing() == Direction.WEST ? 0.25 : 0.0), (double)(this.getFacing() == Direction.SOUTH ? 0.75 : 1.0), (double)1.0, (double)(this.getFacing() == Direction.EAST ? 0.75 : 1.0));
        }
        if (new BlockPos(6, 3, 0).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)(this.getFacing() == Direction.SOUTH ? 0.25 : 0.0), (double)0.0, (double)(this.getFacing() == Direction.EAST ? 0.25 : 0.0), (double)(this.getFacing() == Direction.NORTH ? 0.75 : 1.0), (double)1.0, (double)(this.getFacing() == Direction.WEST ? 0.75 : 1.0));
        }
        if (ImmutableSet.of((Object)new BlockPos(1, 2, 0), (Object)new BlockPos(1, 4, 0)).contains((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)(this.getFacing() == Direction.NORTH ? 0.25 : 0.0), (double)0.0, (double)(this.getFacing() == Direction.WEST ? 0.25 : 0.0), (double)(this.getFacing() == Direction.SOUTH ? 0.75 : 1.0), (double)1.0, (double)(this.getFacing() == Direction.EAST ? 0.75 : 1.0));
        }
        if (ImmutableSet.of((Object)new BlockPos(5, 2, 0), (Object)new BlockPos(5, 4, 0)).contains((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)(this.getFacing() == Direction.SOUTH ? 0.25 : 0.0), (double)0.0, (double)(this.getFacing() == Direction.EAST ? 0.25 : 0.0), (double)(this.getFacing() == Direction.NORTH ? 0.75 : 1.0), (double)1.0, (double)(this.getFacing() == Direction.WEST ? 0.75 : 1.0));
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }
}

